/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.ByteValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.FloatValueCommand;
import com.google.gwt.rpc.client.ast.HasSetters;
import com.google.gwt.rpc.client.ast.IdentityValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.IntValueCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.ReturnCommand;
import com.google.gwt.rpc.client.ast.RpcCommand;
import com.google.gwt.rpc.client.ast.ScalarValueCommand;
import com.google.gwt.rpc.client.ast.ShortValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.Pair;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePayloadDecoder {
    private static final String OBFUSCATED_CLASS_PREFIX = "Class$ ";
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private final Map<Integer, ValueCommand> backRefs = new HashMap<Integer, ValueCommand>();
    private final Map<String, Class<?>> classCache = new HashMap(PRIMITIVE_TYPES);
    private final ClientOracle clientOracle;
    private final Stack<RpcCommand> commands = new Stack();
    private int idx;
    private final CharSequence payload;
    private ReturnCommand toReturn;
    private ValueCommand toThrow;

    public SimplePayloadDecoder(ClientOracle clientOracle, CharSequence payload) throws ClassNotFoundException {
        this.clientOracle = clientOracle;
        this.payload = payload;
        while (this.toReturn == null && this.idx < payload.length()) {
            this.decodeCommand();
            if (this.toThrow == null) continue;
            return;
        }
    }

    public ValueCommand getThrownValue() {
        return this.toThrow;
    }

    public List<ValueCommand> getValues() {
        return this.toReturn == null ? Collections.emptyList() : this.toReturn.getValues();
    }

    private void decodeCommand() throws ClassNotFoundException {
        char command = this.next();
        if (command == '\n') {
            command = this.next();
        }
        String token = this.token();
        switch (command) {
            case 'Z': {
                this.push((ScalarValueCommand)new BooleanValueCommand(token.equals("1")));
                break;
            }
            case 'B': {
                this.push((ScalarValueCommand)new ByteValueCommand(Byte.valueOf(token)));
                break;
            }
            case 'C': {
                this.push((ScalarValueCommand)new CharValueCommand(Character.valueOf((char)Integer.valueOf(token).intValue())));
                break;
            }
            case 'D': {
                this.push((ScalarValueCommand)new DoubleValueCommand(Double.valueOf(token)));
                break;
            }
            case 'F': {
                this.push((ScalarValueCommand)new FloatValueCommand(Float.valueOf(token)));
                break;
            }
            case 'I': {
                this.push((ScalarValueCommand)new IntValueCommand(Integer.valueOf(token)));
                break;
            }
            case 'J': {
                this.push((ScalarValueCommand)new LongValueCommand(Long.valueOf(token)));
                break;
            }
            case 'V': {
                this.push((ScalarValueCommand)NullValueCommand.INSTANCE);
                break;
            }
            case 'S': {
                this.push((ScalarValueCommand)new ShortValueCommand(Short.valueOf(token)));
                break;
            }
            case '\"': {
                int length = Integer.valueOf(token);
                String value = this.next(length);
                if (this.next() != '~') {
                    throw new RuntimeException("Overran string");
                }
                this.push(new StringValueCommand(value));
                break;
            }
            case 'E': {
                EnumValueCommand x = new EnumValueCommand();
                this.push((IdentityValueCommand)x);
                String name = this.readCommand(StringValueCommand.class).getValue();
                Class<Enum> clazz = this.findClass(token).asSubclass(Enum.class);
                Enum enumValue = Enum.valueOf(clazz, name);
                x.setValue(enumValue);
                break;
            }
            case '[': {
                Class<?> clazz;
                Class<?> leaf = this.findClass(token);
                Integer numDims = this.readCommand(IntValueCommand.class).getValue();
                if (numDims > 1) {
                    int[] dims = new int[numDims - 1];
                    clazz = Array.newInstance(leaf, dims).getClass();
                } else {
                    clazz = leaf;
                }
                ArrayValueCommand x = new ArrayValueCommand(clazz);
                this.push((IdentityValueCommand)x);
                int length = this.readCommand(IntValueCommand.class).getValue();
                for (int i = 0; i < length; ++i) {
                    x.add(this.readCommand(ValueCommand.class));
                }
                break;
            }
            case 'L': {
                Class<?> clazz = this.findClass(token);
                InstantiateCommand x = new InstantiateCommand(clazz);
                this.push((IdentityValueCommand)x);
                this.readSetters(clazz, (HasSetters)x);
                break;
            }
            case '!': {
                Class<?> manualType;
                Class<?> clazz = this.findClass(token);
                Class<?> serializerClass = null;
                for (manualType = clazz; manualType != null && (serializerClass = SerializabilityUtil.hasCustomFieldSerializer(manualType)) == null; manualType = manualType.getSuperclass()) {
                }
                InvokeCustomFieldSerializerCommand x = new InvokeCustomFieldSerializerCommand(clazz, serializerClass, manualType);
                this.push((IdentityValueCommand)x);
                this.readFields(x);
                this.readSetters(clazz, (HasSetters)x);
                break;
            }
            case 'R': {
                this.toReturn = new ReturnCommand();
                int toRead = Integer.valueOf(token);
                for (int i = 0; i < toRead; ++i) {
                    this.toReturn.addValue(this.readCommand(ValueCommand.class));
                }
                break;
            }
            case 'T': {
                this.toThrow = this.readCommand(ValueCommand.class);
                break;
            }
            case '@': {
                ValueCommand x = this.backRefs.get(Integer.valueOf(token));
                assert (x != null) : "Could not find backref";
                this.commands.push((RpcCommand)x);
                break;
            }
            case '~': {
                throw new RuntimeException("Segmentation overrun at " + this.idx);
            }
            default: {
                throw new RuntimeException("Unknown command " + command);
            }
        }
    }

    private Class<?> findClass(String token) throws ClassNotFoundException {
        Class<?> clazz = this.classCache.get(token);
        if (clazz != null) {
            return clazz;
        }
        String className = this.clientOracle.getTypeName(token);
        if (className == null) {
            className = token;
        }
        if (className.contains("[]")) {
            int firstIndex = -1;
            int j = -1;
            int dims = 0;
            while ((j = className.indexOf("[", j + 1)) != -1) {
                if (dims++ != 0) continue;
                firstIndex = j;
            }
            Class<?> componentType = this.findClass(className.substring(0, firstIndex));
            assert (componentType != null) : "Could not determine component type with " + className.substring(0, firstIndex);
            clazz = Array.newInstance(componentType, new int[dims]).getClass();
        } else {
            ClassLoader myCCL = this.getClass().getClassLoader();
            clazz = Class.forName(className, false, myCCL);
        }
        this.classCache.put(token, clazz);
        return clazz;
    }

    private char next() {
        int c;
        if ((c = this.payload.charAt(this.idx++)) == 92) {
            switch (this.payload.charAt(this.idx++)) {
                case '0': {
                    c = 0;
                    break;
                }
                case '!': {
                    c = 124;
                    break;
                }
                case 'b': {
                    c = 8;
                    break;
                }
                case 't': {
                    c = 9;
                    break;
                }
                case 'n': {
                    c = 10;
                    break;
                }
                case 'f': {
                    c = 12;
                    break;
                }
                case 'r': {
                    c = 13;
                    break;
                }
                case '\\': {
                    c = 92;
                    break;
                }
                case '\"': {
                    c = 34;
                    break;
                }
                case 'u': {
                    c = (char)Integer.parseInt(((Object)this.payload.subSequence(this.idx, this.idx += 4)).toString(), 16);
                    break;
                }
                case 'x': {
                    c = (char)Integer.parseInt(((Object)this.payload.subSequence(this.idx, this.idx += 2)).toString(), 16);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled escape " + this.payload.charAt(this.idx));
                }
            }
        }
        return (char)c;
    }

    private String next(int count) {
        StringBuilder sb = new StringBuilder();
        while (count-- > 0) {
            sb.append(this.next());
        }
        return sb.toString();
    }

    private void push(IdentityValueCommand x) {
        this.commands.push((RpcCommand)x);
        this.backRefs.put(this.backRefs.size(), (ValueCommand)x);
    }

    private void push(ScalarValueCommand x) {
        this.commands.push((RpcCommand)x);
    }

    private void push(StringValueCommand x) {
        this.commands.push((RpcCommand)x);
        this.backRefs.put(this.backRefs.size(), (ValueCommand)x);
    }

    private <T extends RpcCommand> T readCommand(Class<T> clazz) throws ClassNotFoundException {
        this.decodeCommand();
        RpcCommand value = this.commands.pop();
        assert (clazz.isInstance(value)) : "Cannot assign a " + value.getClass().getName() + " to " + clazz.getName();
        return (T)((RpcCommand)clazz.cast(value));
    }

    private void readFields(InvokeCustomFieldSerializerCommand x) throws ClassNotFoundException {
        int length = this.readCommand(IntValueCommand.class).getValue();
        for (int i = 0; i < length; ++i) {
            x.addValue(this.readCommand(ValueCommand.class));
        }
    }

    private void readSetter(Class<?> clazz, HasSetters x) throws ClassNotFoundException {
        String fieldDeclClassName;
        if (!this.clientOracle.isScript() && (fieldDeclClassName = this.readCommand(StringValueCommand.class).getValue()) != null) {
            clazz = this.findClass(fieldDeclClassName);
        }
        String fieldId = this.readCommand(StringValueCommand.class).getValue();
        Pair<Class<?>, String> data = this.clientOracle.getFieldName(clazz, fieldId);
        Class<?> fieldDeclClass = data.getA();
        String fieldName = data.getB();
        ValueCommand value = this.readCommand(ValueCommand.class);
        x.set(fieldDeclClass, fieldName, value);
    }

    private void readSetters(Class<?> clazz, HasSetters x) throws ClassNotFoundException {
        int length = this.readCommand(IntValueCommand.class).getValue();
        for (int i = 0; i < length; ++i) {
            this.readSetter(clazz, x);
        }
    }

    private String token() {
        StringBuilder sb = new StringBuilder();
        char n = this.next();
        while (n != '~') {
            sb.append(n);
            n = this.next();
        }
        return sb.toString();
    }

    static {
        PRIMITIVE_TYPES.put("Class$ Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("Class$ B", Byte.TYPE);
        PRIMITIVE_TYPES.put("Class$ C", Character.TYPE);
        PRIMITIVE_TYPES.put("Class$ D", Double.TYPE);
        PRIMITIVE_TYPES.put("Class$ F", Float.TYPE);
        PRIMITIVE_TYPES.put("Class$ I", Integer.TYPE);
        PRIMITIVE_TYPES.put("Class$ J", Long.TYPE);
        PRIMITIVE_TYPES.put("Class$ S", Short.TYPE);
        PRIMITIVE_TYPES.put("Class$ V", Void.TYPE);
        PRIMITIVE_TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVE_TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVE_TYPES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVE_TYPES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVE_TYPES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVE_TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVE_TYPES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVE_TYPES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_TYPES.put(Void.TYPE.getName(), Void.TYPE);
    }
}

