/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;

public class CheckFeatureId
implements AnalyserTask {
    static final String CONFIG_KEY_ACCEPTED_FEATURE_IDS = "accepted-feature-ids";

    @Override
    public String getId() {
        return "feature-id";
    }

    @Override
    public String getName() {
        return "Restrict feature id format";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        Map<String, String> cfg = ctx.getConfiguration();
        String acceptedFeatureIds = cfg.get(CONFIG_KEY_ACCEPTED_FEATURE_IDS);
        if (acceptedFeatureIds == null) {
            throw new IllegalArgumentException("Missing 'accepted-feature-ids' configuration for feature-id analyser.");
        }
        ArrayList<ArtifactId> acceptedArtifactIds = new ArrayList<ArtifactId>();
        for (String acceptedFeatureId : acceptedFeatureIds.split(",")) {
            try {
                acceptedArtifactIds.add(ArtifactId.fromMvnId((String)acceptedFeatureId));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid 'accepted-feature-ids' configuration for feature-id analyser, element '" + acceptedFeatureId + "' is not a valid maven coordinate string in format 'groupId:artifactId[:packaging[:classifier]]:version'", e);
            }
        }
        if (!CheckFeatureId.matchesAnyOf(ctx.getFeature().getId(), acceptedArtifactIds)) {
            ctx.reportError("Feature " + ctx.getFeature().getId() + " does not match any of the accepted feature ids ");
        }
    }

    static boolean matchesAnyOf(ArtifactId artifactId, Collection<ArtifactId> expectedArtifactIds) {
        for (ArtifactId expectedArtifactId : expectedArtifactIds) {
            if (!CheckFeatureId.matches(artifactId, expectedArtifactId)) continue;
            return true;
        }
        return false;
    }

    static boolean matches(ArtifactId artifactId, ArtifactId expectedArtifactId) {
        if (!expectedArtifactId.getGroupId().equals(artifactId.getGroupId()) && !expectedArtifactId.getGroupId().equals("*")) {
            return false;
        }
        if (!expectedArtifactId.getArtifactId().equals(artifactId.getArtifactId()) && !expectedArtifactId.getArtifactId().equals("*")) {
            return false;
        }
        if (!expectedArtifactId.getVersion().equals(artifactId.getVersion()) && !expectedArtifactId.getVersion().equals("*")) {
            return false;
        }
        if (!expectedArtifactId.getType().equals(artifactId.getType()) && !expectedArtifactId.getType().equals("*")) {
            return false;
        }
        return (expectedArtifactId.getClassifier() != null || artifactId.getClassifier() == null) && (expectedArtifactId.getClassifier() == null || expectedArtifactId.getClassifier().equals(artifactId.getClassifier()) || expectedArtifactId.getClassifier().equals("*"));
    }
}

