/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.modelconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.FeatureBuilder;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.provisioning.model.KeyValueMap;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;
import org.apache.sling.provisioning.model.io.ModelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureToProvisioning {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureToProvisioning.class);
    static final String PROVISIONING_MODEL_NAME_VARIABLE = "provisioning.model.name";
    static final String PROVISIONING_RUNMODES = "provisioning.runmodes";

    public static void convert(File inputFile, File outputFile, FeatureProvider fp, File ... additionalInputFiles) throws UncheckedIOException {
        Object featureNameVar;
        if (outputFile.exists() && outputFile.lastModified() >= inputFile.lastModified()) {
            LOGGER.debug("Skipping the generation of {} as this file already exists and is not older.", (Object)outputFile);
            return;
        }
        Feature feature = FeatureToProvisioning.getFeature(inputFile);
        if (feature.getPrototype() != null) {
            feature = FeatureToProvisioning.handlePrototype(feature, additionalInputFiles, fp);
        }
        String provModelName = (featureNameVar = feature.getVariables().remove(PROVISIONING_MODEL_NAME_VARIABLE)) instanceof String ? (String)featureNameVar : feature.getId().getArtifactId();
        String runMode = (String)feature.getVariables().remove(PROVISIONING_RUNMODES);
        String[] runModes = null;
        if (runMode != null) {
            runModes = runMode.split(",");
        }
        FeatureToProvisioning.convert(provModelName, feature, inputFile.getName(), outputFile.getAbsolutePath(), runModes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Feature getFeature(File file) throws UncheckedIOException {
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            Feature feature = FeatureJSONReader.read((Reader)r, (String)file.toURI().toURL().toString());
            return feature;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Feature handlePrototype(Feature feature, File[] additionalFiles, FeatureProvider fp) throws UncheckedIOException {
        Map features = Stream.of(additionalFiles).map(FeatureToProvisioning::getFeature).collect(Collectors.toMap(Feature::getId, Function.identity()));
        BuilderContext bc = new BuilderContext(id -> features.containsKey(id) ? (Feature)features.get(id) : fp.provide(id));
        return FeatureBuilder.assemble((Feature)feature, (BuilderContext)bc);
    }

    /*
     * Could not resolve type clashes
     */
    private static void convert(String provModelName, Feature feature, String featureFileName, String outputFile, String[] runModes) {
        String name;
        org.apache.sling.provisioning.model.Feature provModel = new org.apache.sling.provisioning.model.Feature(provModelName);
        HashMap<Object, org.apache.sling.provisioning.model.Feature> additionalFeatures = new HashMap<Object, org.apache.sling.provisioning.model.Feature>();
        if (runModes != null && runModes.length == 0) {
            runModes = null;
        }
        KeyValueMap vars = provModel.getVariables();
        for (Iterator entry : feature.getVariables().entrySet()) {
            vars.put((String)entry.getKey(), entry.getValue());
        }
        HashMap<Configuration, Artifact> configBundleMap = new HashMap<Configuration, Artifact>();
        for (Artifact bundle : feature.getBundles()) {
            ArtifactId id = bundle.getId();
            org.apache.sling.provisioning.model.Artifact newBundle = new org.apache.sling.provisioning.model.Artifact(id.getGroupId(), id.getArtifactId(), id.getVersion(), id.getClassifier(), id.getType());
            Object configs = bundle.getMetadata().get("configurations");
            if (configs instanceof List) {
                for (Object config : (List)configs) {
                    if (!(config instanceof Configuration)) continue;
                    configBundleMap.put((Configuration)config, bundle);
                }
            }
            block21: for (Map.Entry prop : bundle.getMetadata().entrySet()) {
                switch ((String)prop.getKey()) {
                    case "start-level": 
                    case "run-modes": {
                        continue block21;
                    }
                }
                newBundle.getMetadata().put(prop.getKey(), prop.getValue());
            }
            String[] bundleRunModes = runModes;
            if (bundleRunModes == null) {
                bundleRunModes = FeatureToProvisioning.getRunModes(bundle);
            }
            int startLevel = bundle.getStartOrder();
            String sl = (String)bundle.getMetadata().get("start-level");
            if (sl != null && sl.startsWith(":")) {
                org.apache.sling.provisioning.model.Feature addFeat;
                if (bundleRunModes != null) {
                    LOGGER.error("Unable to convert feature {}. Run modes must not be defined for bundles with start-level {}", (Object)provModel.getName(), (Object)sl);
                    System.exit(1);
                }
                if ((addFeat = (org.apache.sling.provisioning.model.Feature)additionalFeatures.get(sl)) == null) {
                    addFeat = new org.apache.sling.provisioning.model.Feature(sl);
                    additionalFeatures.put(sl, addFeat);
                }
                addFeat.getOrCreateRunMode(null).getOrCreateArtifactGroup(0).add(newBundle);
                continue;
            }
            if (startLevel == 0) {
                startLevel = sl != null ? Integer.parseInt(sl) : 20;
            }
            provModel.getOrCreateRunMode(bundleRunModes).getOrCreateArtifactGroup(startLevel).add(newBundle);
        }
        for (Configuration cfg : feature.getConfigurations()) {
            org.apache.sling.provisioning.model.Configuration c;
            ArrayList<String> runModeList = new ArrayList<String>();
            if (Configuration.isFactoryConfiguration((String)cfg.getPid())) {
                name = FeatureToProvisioning.decodeRunModes(Configuration.getName((String)cfg.getPid()), runModeList);
                c = new org.apache.sling.provisioning.model.Configuration(name, Configuration.getFactoryPid((String)cfg.getPid()));
            } else {
                String pid = FeatureToProvisioning.decodeRunModes(cfg.getPid(), runModeList);
                c = new org.apache.sling.provisioning.model.Configuration(pid, null);
            }
            Enumeration keys = cfg.getConfigurationProperties().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object val = cfg.getProperties().get(key);
                if (key.startsWith("..")) {
                    key = ":" + key.substring(2);
                }
                c.getProperties().put(key, val);
            }
            String[] cfgRunModes = runModes;
            if (cfgRunModes == null && (cfgRunModes = runModeList.toArray(new String[0])).length == 0) {
                cfgRunModes = null;
            }
            provModel.getOrCreateRunMode(cfgRunModes).getConfigurations().add((Object)c);
        }
        for (Map.Entry prop : feature.getFrameworkProperties().entrySet()) {
            Object key = (String)prop.getKey();
            int idx = ((String)key).indexOf(".runmodes:");
            if (idx > 0) {
                String rm = ((String)key).substring(idx + ".runmodes:".length());
                String[] runmodes = rm.split(",");
                key = ((String)key).substring(0, idx);
                provModel.getOrCreateRunMode(runmodes).getSettings().put((String)key, prop.getValue());
                continue;
            }
            provModel.getOrCreateRunMode(null).getSettings().put((String)key, prop.getValue());
        }
        for (Extension ext : feature.getExtensions()) {
            if ("content-packages".equals(ext.getName())) {
                for (Artifact cp : ext.getArtifacts()) {
                    String[] extRunModes = runModes;
                    ArtifactId id = cp.getId();
                    org.apache.sling.provisioning.model.Artifact newCP = new org.apache.sling.provisioning.model.Artifact(id.getGroupId(), id.getArtifactId(), id.getVersion(), id.getClassifier(), id.getType());
                    for (Map.Entry prop : cp.getMetadata().entrySet()) {
                        if (((String)prop.getKey()).equals("runmodes")) {
                            if (extRunModes != null) continue;
                            extRunModes = ((String)prop.getValue()).split(",");
                            continue;
                        }
                        newCP.getMetadata().put(prop.getKey(), prop.getValue());
                    }
                    provModel.getOrCreateRunMode(extRunModes).getOrCreateArtifactGroup(20).add(newCP);
                }
                continue;
            }
            if ("repoinit".equals(ext.getName())) {
                String repoinitContents;
                if (ext.getType() == ExtensionType.TEXT) {
                    repoinitContents = ext.getText();
                } else if (ext.getType() == ExtensionType.JSON) {
                    JsonReader reader = Json.createReader((Reader)new StringReader(ext.getJSON()));
                    JsonArray arr = reader.readArray();
                    StringBuilder sb = new StringBuilder();
                    for (JsonValue v : arr) {
                        if (!(v instanceof JsonString)) continue;
                        sb.append(((JsonString)v).getString());
                        sb.append('\n');
                    }
                    repoinitContents = sb.toString();
                } else {
                    repoinitContents = null;
                    LOGGER.error("Unable to convert repoinit extension with artifacts");
                    System.exit(1);
                }
                if (runModes == null) {
                    Section section = new Section("repoinit");
                    section.setContents(repoinitContents);
                    provModel.getAdditionalSections().add(section);
                    continue;
                }
                int lastDot = featureFileName.lastIndexOf(46);
                name = lastDot == -1 ? featureFileName : featureFileName.substring(0, lastDot);
                name = name.replace('-', '_');
                RunMode runMode = provModel.getOrCreateRunMode(runModes);
                org.apache.sling.provisioning.model.Configuration repoinitCfg = new org.apache.sling.provisioning.model.Configuration(name, "org.apache.sling.jcr.repoinit.RepositoryInitializer");
                repoinitCfg.getProperties().put("scripts", repoinitContents);
                runMode.getConfigurations().add((Object)repoinitCfg);
                continue;
            }
            if (!ext.isRequired()) continue;
            LOGGER.error("Unable to convert required extension {}", (Object)ext.getName());
            System.exit(1);
        }
        String out = outputFile;
        File file = new File(out);
        Model m = new Model();
        m.getFeatures().add(provModel);
        for (org.apache.sling.provisioning.model.Feature addFeat : additionalFeatures.values()) {
            m.getFeatures().add(addFeat);
        }
        try (FileWriter writer = new FileWriter(file);){
            ModelWriter.write((Writer)writer, (Model)m);
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to write feature to {} : {}", new Object[]{out, ioe.getMessage(), ioe});
            System.exit(1);
        }
    }

    private static String decodeRunModes(String pid, List<String> runModes) {
        int rmIdx = (pid = pid.replaceAll("[.][.](\\w+)", ":$1")).indexOf(".runmodes.");
        if (rmIdx > 0) {
            String rm = pid.substring(rmIdx + ".runmodes.".length());
            pid = pid.substring(0, rmIdx);
            runModes.addAll(Arrays.asList(rm.split("[.]")));
        }
        return pid;
    }

    private static String[] getRunModes(Artifact bundle) {
        String runMode = (String)bundle.getMetadata().get("run-modes");
        String[] runModes = runMode != null ? runMode.split(",") : null;
        return runModes;
    }
}

