/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.hapi.HApiException;
import org.apache.sling.hapi.HApiProperty;
import org.apache.sling.hapi.HApiType;
import org.apache.sling.hapi.HApiUtil;
import org.apache.sling.hapi.impl.TypesCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HApiTypeLazyWrapper
implements HApiType {
    public static final Logger LOG = LoggerFactory.getLogger(HApiTypeLazyWrapper.class);
    private final HApiUtil util;
    private final ResourceResolver resolver;
    private String serverUrl;
    private final Resource resource;

    public HApiTypeLazyWrapper(HApiUtil util, ResourceResolver resolver, String serverUrl, String name) {
        this.util = util;
        this.resolver = resolver;
        this.serverUrl = serverUrl;
        try {
            this.resource = util.getTypeResource(resolver, name);
        }
        catch (RepositoryException e) {
            throw new HApiException("Can't find type " + name + "!", e);
        }
    }

    public HApiTypeLazyWrapper(HApiUtil util, ResourceResolver resolver, String serverUrl, Resource resource) {
        this.util = util;
        this.resolver = resolver;
        this.serverUrl = serverUrl;
        this.resource = resource;
    }

    private HApiType getTypeFromCache() {
        try {
            return TypesCache.getInstance(this.util).getType(this.resolver, this.resource);
        }
        catch (RepositoryException e) {
            String name = null != this.resource ? this.resource.getName() : "";
            throw new HApiException("Can't find type " + name + "!", e);
        }
    }

    @Override
    public String getName() {
        return this.getTypeFromCache().getName();
    }

    @Override
    public String getDescription() {
        return this.getTypeFromCache().getDescription();
    }

    @Override
    public String getPath() {
        return this.getTypeFromCache().getPath();
    }

    @Override
    public String getUrl() {
        return this.serverUrl + this.getPath() + ".html";
    }

    @Override
    public String getFqdn() {
        return this.getTypeFromCache().getFqdn();
    }

    @Override
    public List<String> getParameters() {
        return this.getTypeFromCache().getParameters();
    }

    @Override
    public Map<String, HApiProperty> getProperties() {
        return this.getTypeFromCache().getProperties();
    }

    @Override
    public Map<String, HApiProperty> getAllProperties() {
        return this.getAllProperties(this);
    }

    private Map<String, HApiProperty> getAllProperties(HApiType rootType) {
        HApiType parent = this.getParent(rootType);
        HashMap<String, HApiProperty> allProps = new HashMap<String, HApiProperty>();
        LOG.debug("parent: {}", (Object)parent);
        if (null != parent) {
            Map<String, HApiProperty> parentProps = parent instanceof HApiTypeLazyWrapper ? ((HApiTypeLazyWrapper)parent).getAllProperties(rootType) : parent.getAllProperties();
            LOG.debug("parent props: {}", parentProps);
            allProps.putAll(parentProps);
        }
        allProps.putAll(this.getProperties());
        return allProps;
    }

    @Override
    public HApiType getParent() {
        return this.getTypeFromCache().getParent();
    }

    private HApiType getParent(HApiType rootType) {
        if (this.equals(rootType)) {
            return null;
        }
        return this.getParent();
    }

    @Override
    public boolean isAbstract() {
        return this.getTypeFromCache().isAbstract();
    }

    public String toString() {
        return "[Weak reference] " + this.getName() + "(" + this.getPath() + "): Properties: " + this.getProperties();
    }
}

