/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.classloader.internal.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.classloader.internal.Util;
import org.apache.sling.jcr.classloader.internal.net.JCRURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRURLConnection
extends URLConnection {
    private static final Logger log = LoggerFactory.getLogger(JCRURLConnection.class);
    private static final String CONTENT_LENGTH = "content-length";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String APPLICATION_OCTET = "application/octet-stream";
    private static final String TEXT_PLAIN = "text/plain";
    private final JCRURLHandler handler;
    private byte[] contents;
    private String contentType;
    private String contentEncoding;
    private int contentLength;
    private long lastModified;

    JCRURLConnection(URL url, JCRURLHandler handler) {
        super(url);
        this.handler = handler;
    }

    private String getPath() {
        return this.handler.getPath();
    }

    private byte[] getContents() throws IOException {
        this.connect();
        return this.contents;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            Session session = null;
            try {
                String contentType;
                session = this.handler.getClassLoaderWriter().createSession();
                Node node = (Node)session.getItem(this.getPath());
                Property property = Util.getProperty((Item)node);
                if (property == null) {
                    throw this.failure("connect", "Multivalue property not supported", null);
                }
                byte[] contents = Util.getBytes(node);
                String contentEncoding = null;
                Node parent = property.getParent();
                long lastModified = parent.hasProperty("jcr:lastModified") ? parent.getProperty("jcr:lastModified").getLong() : 0L;
                if (parent.hasProperty("jcr:mimeType")) {
                    contentType = parent.getProperty("jcr:mimeType").getString();
                } else {
                    contentType = JCRURLConnection.guessContentTypeFromName(node.getName());
                    if (contentType == null) {
                        String string = contentType = property.getType() == 2 ? APPLICATION_OCTET : TEXT_PLAIN;
                    }
                }
                if (parent.hasProperty("jcr:encoding")) {
                    contentEncoding = parent.getProperty("jcr:encoding").getString();
                }
                log.debug("connect: Using property '{}' with content type '{}' for {} bytes", new Object[]{property.getPath(), contentType, new Integer(this.contentLength)});
                this.contents = contents;
                this.contentType = contentType;
                this.contentEncoding = contentEncoding;
                this.contentLength = contents.length;
                this.lastModified = lastModified;
                this.connected = true;
            }
            catch (RepositoryException re) {
                throw this.failure("connect", re.toString(), re);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContents());
    }

    @Override
    public String getHeaderField(String s) {
        try {
            this.connect();
            if (CONTENT_LENGTH.equalsIgnoreCase(s)) {
                return String.valueOf(this.contentLength);
            }
            if (CONTENT_TYPE.equalsIgnoreCase(s)) {
                return this.contentType;
            }
            if (LAST_MODIFIED.equalsIgnoreCase(s)) {
                return String.valueOf(this.lastModified);
            }
            if (CONTENT_ENCODING.equalsIgnoreCase(s)) {
                return this.contentEncoding;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderField: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    @Override
    public String getHeaderField(int i) {
        try {
            this.connect();
            if (i == 0) {
                return String.valueOf(this.contentLength);
            }
            if (i == 1) {
                return this.contentType;
            }
            if (i == 2) {
                return String.valueOf(this.lastModified);
            }
            if (i == 3) {
                return this.contentEncoding;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderField: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int i) {
        try {
            this.connect();
            if (i == 0) {
                return CONTENT_LENGTH;
            }
            if (i == 1) {
                return CONTENT_TYPE;
            }
            if (i == 2) {
                return LAST_MODIFIED;
            }
            if (i == 3) {
                return CONTENT_ENCODING;
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderFieldKey: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> fieldMap = new HashMap<String, List<String>>();
        try {
            this.connect();
            fieldMap.put(CONTENT_LENGTH, this.toList(String.valueOf(this.contentLength)));
            fieldMap.put(CONTENT_TYPE, this.toList(this.contentType));
            fieldMap.put(LAST_MODIFIED, this.toList(String.valueOf(this.lastModified)));
            if (this.contentEncoding != null) {
                fieldMap.put(CONTENT_ENCODING, this.toList(this.contentEncoding));
            }
        }
        catch (IOException ioe) {
            log.info("getHeaderFields: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
        }
        return Collections.unmodifiableMap(fieldMap);
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
            return this.contentType;
        }
        catch (IOException ioe) {
            log.info("getContentType: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return null;
        }
    }

    @Override
    public String getContentEncoding() {
        try {
            this.connect();
            return this.contentEncoding;
        }
        catch (IOException ioe) {
            log.info("getContentEncoding: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return null;
        }
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return this.contentLength;
        }
        catch (IOException ioe) {
            log.info("getContentLength: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return -1;
        }
    }

    @Override
    public long getLastModified() {
        try {
            this.connect();
            return this.lastModified;
        }
        catch (IOException ioe) {
            log.info("getLastModified: Problem connecting: " + ioe.toString());
            log.debug("dump", (Throwable)ioe);
            return -1L;
        }
    }

    private IOException failure(String method, String message, Throwable cause) {
        log.info(method + ": URL: " + this.url.toExternalForm() + ", Reason: " + message);
        if (cause != null) {
            log.debug("dump", cause);
        }
        IOException ioe = new IOException(this.url.toExternalForm() + ": " + message);
        ioe.initCause(cause);
        return ioe;
    }

    private List<String> toList(String value) {
        String[] values = new String[]{value};
        List<String> valueList = Arrays.asList(values);
        return Collections.unmodifiableList(valueList);
    }
}

