/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.simple;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.nosql.generic.simple.provider.SimpleNoSqlResourceProviderFactory;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SimpleNoSqlResourceProviderQueryTest {
    @Rule
    public SlingContext context = new SlingContext(ResourceResolverType.JCR_MOCK);
    private Resource testRoot;

    @Before
    public void setUp() throws Exception {
        this.context.registerInjectActivateService((Object)new SimpleNoSqlResourceProviderFactory(), (Map)ImmutableMap.builder().put((Object)"provider.roots", (Object)"/nosql-simple").build());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", "nt:unstructured");
        Resource root = this.context.resourceResolver().getResource("/");
        Resource noSqlRoot = this.context.resourceResolver().create(root, "nosql-simple", props);
        this.testRoot = this.context.resourceResolver().create(noSqlRoot, "test", props);
        this.context.resourceResolver().create(this.testRoot, "node1", (Map)ImmutableMap.of((Object)"prop1", (Object)"value1"));
        this.context.resourceResolver().create(this.testRoot, "node2", (Map)ImmutableMap.of((Object)"prop1", (Object)"value2"));
        this.context.resourceResolver().commit();
    }

    @Test
    public void testFindResources_ValidQuery() {
        Iterator result = this.context.resourceResolver().findResources("all", "simple");
        Assert.assertEquals((Object)"/nosql-simple", (Object)((Resource)result.next()).getPath());
        Assert.assertEquals((Object)"/nosql-simple/test", (Object)((Resource)result.next()).getPath());
        Assert.assertEquals((Object)"/nosql-simple/test/node1", (Object)((Resource)result.next()).getPath());
        Assert.assertEquals((Object)"/nosql-simple/test/node2", (Object)((Resource)result.next()).getPath());
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testFindResources_InvalidQuery() {
        Iterator result = this.context.resourceResolver().findResources("all", "invalid");
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testQueryResources_ValidQuery() {
        Iterator result = this.context.resourceResolver().queryResources("all", "simple");
        Assert.assertNull(((Map)result.next()).get("prop1"));
        Assert.assertNull(((Map)result.next()).get("prop1"));
        Assert.assertEquals((Object)"value1", ((Map)result.next()).get("prop1"));
        Assert.assertEquals((Object)"value2", ((Map)result.next()).get("prop1"));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testQueryResources_InvalidQuery() {
        Iterator result = this.context.resourceResolver().queryResources("all", "invalid");
        Assert.assertFalse((boolean)result.hasNext());
    }
}

