/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.ResourcePredicates;
import org.apache.sling.resource.filter.ResourceStream;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ResourceFilterStream {
    private ResourceStream resources;
    private ResourcePredicates resourcePredicate;
    private Predicate<Resource> branchSelector = resource -> true;
    private Predicate<Resource> childSelector = resource -> true;
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public ResourceFilterStream(Resource resource2, ResourcePredicates filter) {
        this.resources = new ResourceStream(resource2);
        this.resourcePredicate = filter;
    }

    public ResourceFilterStream setBranchSelector(String branchSelector) {
        this.branchSelector = this.resourcePredicate.usingParameterMap(this.parameters).parse(branchSelector);
        return this;
    }

    public ResourceFilterStream setChildSelector(String childSelector) {
        this.childSelector = this.resourcePredicate.usingParameterMap(this.parameters).parse(childSelector);
        return this;
    }

    public ResourceFilterStream addParam(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    public ResourceFilterStream addParams(Map<String, Object> params) {
        this.parameters.putAll(params);
        return this;
    }

    public Stream<Resource> stream() {
        return this.resources.stream(this.branchSelector).filter(this.childSelector);
    }
}

