/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.bundle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.sling.servlets.resolver.internal.bundle.BundledScriptTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"felix.healthcheck.name=BundledScriptTracker"}, service={HealthCheck.class})
@Designate(ocd=BundledScriptTrackerHCConfig.class)
public class BundledScriptTrackerHC
implements HealthCheck {
    private final BundledScriptTracker tracker;
    private final BundleContext bundleContext;
    private final Set<String> expectedBundles = new HashSet<String>();
    private final boolean ignoreNonExistingBundles;

    @Activate
    public BundledScriptTrackerHC(BundleContext context, @Reference BundledScriptTracker tracker, BundledScriptTrackerHCConfig config) {
        this.tracker = tracker;
        this.bundleContext = context;
        this.ignoreNonExistingBundles = config.ignoreNonExistingBundles();
        if (config.mandatoryBundles() != null) {
            this.expectedBundles.addAll(Arrays.asList(config.mandatoryBundles()));
            BundledScriptTracker.LOGGER.info("Healthcheck configured with mandatory bundles {} for tags {}, ignoreNonExistingBundles = {}", new Object[]{Arrays.toString(config.mandatoryBundles()), Arrays.toString(config.hc_tags()), this.ignoreNonExistingBundles});
        }
    }

    public Result execute() {
        if (this.expectedBundles.isEmpty()) {
            return new Result(Result.Status.OK, "Health check is not configured.");
        }
        Set<String> mandatoryAvailableBundles = this.ignoreNonExistingBundles ? BundledScriptTrackerHC.filterForExistingBundles(this.bundleContext, this.expectedBundles) : this.expectedBundles;
        if (this.tracker.getRegisteredBundles().containsAll(mandatoryAvailableBundles)) {
            return new Result(Result.Status.OK, "All expected bundles have registered their scripts.");
        }
        FormattingResultLog log = new FormattingResultLog();
        log.warn("Expected bundles : {}, registered bundles: {}", new Object[]{mandatoryAvailableBundles, this.tracker.getRegisteredBundles()});
        return new Result((ResultLog)log);
    }

    protected static Set<String> filterForExistingBundles(BundleContext bundleContext, Set<String> expectedBundles) {
        List<Bundle> allBundles = Arrays.asList(bundleContext.getBundles());
        return allBundles.stream().map(Bundle::getSymbolicName).filter(s -> expectedBundles.contains(s)).collect(Collectors.toSet());
    }

    @ObjectClassDefinition
    public static @interface BundledScriptTrackerHCConfig {
        @AttributeDefinition(name="Mandatory Bundles", description="A list of symbolic bundle names for which the script registration process must have been successfully completed for the health check to report ok.")
        public String[] mandatoryBundles();

        @AttributeDefinition(name="Check for bundle presence", description="If disabled, bundles listed as mandatory are ignored if no bundle with that symbolic name is present")
        public boolean ignoreNonExistingBundles() default false;

        @AttributeDefinition(name="healthcheck tags", description="the tags under which the healthcheck should be registered")
        public String[] hc_tags() default {"systemready"};
    }
}

