/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.ReferenceViolationException;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service1Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service2Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service3Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service4;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service4Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service5;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service5Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service6;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service6Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service7;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service7Constructor;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service9;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.ServiceReferenceInConstructor;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class OsgiServiceUtilActivateDeactivateTest {
    private Map<String, Object> map = Map.of("prop1", "value1", "prop2.with.periods", "value2", "prop3-with-hyphens", "value3");
    private BundleContext bundleContext = MockOsgi.newBundleContext();

    @Test
    public void testService1() {
        Service1 service = new Service1();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService1Constructor() {
        Service1Constructor service = (Service1Constructor)MockOsgi.activateInjectServices(Service1Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService2() {
        Service2 service = new Service2();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, (Object[])new Object[]{"prop1", "value1"}));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService2Constructor() {
        Service2Constructor service = (Service2Constructor)MockOsgi.activateInjectServices(Service2Constructor.class, (BundleContext)this.bundleContext, (Object[])new Object[]{"prop1", "value1"});
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService3() {
        Service3 service = new Service3();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals((Object)"value1", service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService3Constructor() {
        Service3Constructor service = (Service3Constructor)MockOsgi.activateInjectServices(Service3Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals((Object)"value1", service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService4() {
        Service4 service = new Service4();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals(this.map, Map.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService4Constructor() {
        Service4Constructor service = (Service4Constructor)MockOsgi.activateInjectServices(Service4Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertEquals(this.map, Map.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService5() {
        Service5 service = new Service5();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService5Constructor() {
        Service5Constructor service = (Service5Constructor)MockOsgi.activateInjectServices(Service5Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService6() {
        Service6 service = new Service6();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals((Object)"value1", service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService6Constructor() {
        Service6Constructor service = (Service6Constructor)MockOsgi.activateInjectServices(Service6Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals((Object)"value1", service.getMap().get("prop1"));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService7() {
        Service7 service = new Service7();
        Assert.assertTrue((boolean)MockOsgi.activate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals(this.map, Map.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testService7Constructor() {
        Service7Constructor service = (Service7Constructor)MockOsgi.activateInjectServices(Service7Constructor.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((boolean)service.isActivated());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getComponentContext().getBundleContext());
        Assert.assertSame((Object)this.bundleContext, (Object)service.getBundleContext());
        Assert.assertEquals(this.map, Map.copyOf(service.getMap()));
        Assert.assertTrue((boolean)MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map));
        Assert.assertFalse((boolean)service.isActivated());
    }

    @Test
    public void testReferenceInConstructor() {
        try {
            MockOsgi.activateInjectServices(ServiceReferenceInConstructor.class, (BundleContext)this.bundleContext);
            Assert.fail((String)"Unresolvable mandatory reference in constructor should lead to ReferenceViolationException");
        }
        catch (ReferenceViolationException e) {
            String regex = "Unable to inject mandatory reference '.*' " + Pattern.quote("(org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.Service1) into constructor parameter 0 for class org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.activatedeactivate.ServiceReferenceInConstructor : no matching services were found.");
            Assert.assertTrue((String)("Expected exception message matching regex:\n" + regex + "\nbut got:\n" + e.getMessage()), (boolean)e.getMessage().matches(regex));
        }
    }

    @Test
    public void testService9ActivateDeactivate() {
        Service9 service = (Service9)MockOsgi.activateInjectServices(Service9.class, (BundleContext)this.bundleContext, this.map);
        Assert.assertEquals(Service9.class, (Object)service.getActivateFromClass());
        MockOsgi.deactivate((Object)service, (BundleContext)this.bundleContext, this.map);
        Assert.assertEquals(Service9.class, (Object)service.getDeactivateFromClass());
    }
}

