/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.samples.sampletests;

import org.apache.sling.junit.annotations.SlingAnnotationsTestRunner;
import org.apache.sling.junit.annotations.TestReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

@RunWith(value=SlingAnnotationsTestRunner.class)
public class OsgiAwareTest {
    @TestReference
    private ConfigurationAdmin configAdmin;
    @TestReference
    private BundleContext bundleContext;

    @Test
    public void testConfigAdmin() throws Exception {
        Assert.assertNotNull((String)"Expecting ConfigurationAdmin to be injected by Sling test runner", (Object)this.configAdmin);
        String name = "TEST_" + this.getClass().getName() + System.currentTimeMillis();
        Assert.assertNotNull((String)("Expecting config " + name + " to be created"), (Object)this.configAdmin.getConfiguration(name));
    }

    @Test
    public void testBundleContext() {
        Assert.assertNotNull((String)"Expecting BundleContext to be injected by Sling test runner", (Object)this.bundleContext);
        String mySymbolicName = "org.apache.sling.testing.samples.sampletests";
        Bundle thisBundle = null;
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!"org.apache.sling.testing.samples.sampletests".equals(b.getSymbolicName())) continue;
            thisBundle = b;
            break;
        }
        Assert.assertNotNull((String)"Expecting to find Bundle org.apache.sling.testing.samples.sampletests", thisBundle);
    }
}

