/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.version.ReadOnlyVersionManager;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.EntryPredicate;
import org.apache.jackrabbit.oak.security.authorization.permission.InternalTreePermission;
import org.apache.jackrabbit.oak.security.authorization.permission.NoPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntryProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.ReadStatus;
import org.apache.jackrabbit.oak.security.authorization.permission.RepoPolicyTreePermission;
import org.apache.jackrabbit.oak.security.authorization.permission.VersionTreePermission;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.collect.ImmutableMap;
import sling-mock-oak.com.google.common.collect.Iterators;

final class CompiledPermissionImpl
implements CompiledPermissions,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(CompiledPermissionImpl.class);
    private static final Map<Long, PrivilegeBits> READ_BITS = ImmutableMap.of(3L, PrivilegeBits.BUILT_IN.get("jcr:read"), 1L, PrivilegeBits.BUILT_IN.get("rep:readNodes"), 2L, PrivilegeBits.BUILT_IN.get("rep:readProperties"), 128L, PrivilegeBits.BUILT_IN.get("jcr:readAccessControl"));
    private final String workspaceName;
    private final ReadPolicy readPolicy;
    private final PermissionStore store;
    private final PermissionEntryProvider userStore;
    private final PermissionEntryProvider groupStore;
    private final TreeTypeProvider typeProvider;
    private final ProviderCtx providerCtx;
    private Root root;
    private ReadOnlyVersionManager versionManager;
    private PrivilegeBitsProvider bitsProvider;

    private CompiledPermissionImpl(@NotNull Set<Principal> principals, @NotNull Root root, @NotNull String workspaceName, @NotNull PermissionStore store, @NotNull ConfigurationParameters options, @NotNull Context ctx, @NotNull ProviderCtx providerCtx) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.providerCtx = providerCtx;
        this.bitsProvider = new PrivilegeBitsProvider(root);
        Set readPaths = options.getConfigValue("readPaths", DEFAULT_READ_PATHS);
        this.readPolicy = readPaths.isEmpty() ? EmptyReadPolicy.INSTANCE : new DefaultReadPolicy(readPaths);
        this.store = store;
        HashSet<String> userNames = new HashSet<String>(principals.size());
        HashSet<String> groupNames = new HashSet<String>(principals.size());
        for (Principal principal : principals) {
            if (GroupPrincipals.isGroup(principal)) {
                groupNames.add(principal.getName());
                continue;
            }
            userNames.add(principal.getName());
        }
        this.userStore = !userNames.isEmpty() ? new PermissionEntryProviderImpl(store, userNames, options) : null;
        this.groupStore = !groupNames.isEmpty() ? new PermissionEntryProviderImpl(store, groupNames, options) : null;
        this.typeProvider = new TreeTypeProvider(ctx);
    }

    static CompiledPermissions create(@NotNull Root root, @NotNull String workspaceName, @NotNull PermissionStore store, @NotNull Set<Principal> principals, @NotNull ConfigurationParameters options, @NotNull Context ctx, @NotNull ProviderCtx providerCtx) {
        Tree permissionsTree = PermissionUtil.getPermissionsRoot(root, workspaceName);
        if (!permissionsTree.exists() || principals.isEmpty()) {
            return NoPermissions.getInstance();
        }
        return new CompiledPermissionImpl(principals, root, workspaceName, store, options, ctx, providerCtx);
    }

    @Override
    public void refresh(@NotNull Root root, @NotNull String workspaceName) {
        this.root = root;
        this.bitsProvider = new PrivilegeBitsProvider(root);
        this.versionManager = null;
        this.store.flush(root);
        if (this.userStore != null) {
            this.userStore.flush();
        }
        if (this.groupStore != null) {
            this.groupStore.flush();
        }
    }

    @Override
    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        return new RepositoryPermission(){

            @Override
            public boolean isGranted(long repositoryPermissions) {
                EntryPredicate predicate = EntryPredicate.create();
                return CompiledPermissionImpl.this.hasPermissions(CompiledPermissionImpl.this.getEntryIterator(predicate), predicate, repositoryPermissions, null);
            }
        };
    }

    @Override
    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        return this.getTreePermission(tree, this.typeProvider.getType(tree, CompiledPermissionImpl.getParentType(parentPermission)), parentPermission);
    }

    @Override
    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        if (tree.isRoot()) {
            return this.createRootPermission(tree);
        }
        if (parentPermission instanceof VersionTreePermission) {
            return ((VersionTreePermission)parentPermission).createChildPermission(tree);
        }
        if (parentPermission instanceof RepoPolicyTreePermission) {
            return ((RepoPolicyTreePermission)parentPermission).getChildPermission();
        }
        switch (type) {
            case HIDDEN: {
                return TreePermission.ALL;
            }
            case VERSION: {
                if (ReadOnlyVersionManager.isVersionStoreTree(tree)) {
                    return new TreePermissionImpl(tree, TreeType.VERSION, parentPermission);
                }
                Tree versionableTree = this.getVersionManager().getVersionable(tree, this.workspaceName);
                if (versionableTree == null) {
                    log.warn("Cannot retrieve versionable node for {}", (Object)tree.getPath());
                    return TreePermission.EMPTY;
                }
                return new VersionTreePermission(tree, this.buildVersionDelegatee(versionableTree), this.providerCtx.getTreeProvider());
            }
            case ACCESS_CONTROL: {
                if ("rep:repoPolicy".equals(tree.getName())) {
                    return new RepoPolicyTreePermission(this.getRepositoryPermission());
                }
                return new TreePermissionImpl(tree, type, parentPermission);
            }
            case INTERNAL: {
                return InternalTreePermission.INSTANCE;
            }
        }
        return new TreePermissionImpl(tree, type, parentPermission);
    }

    @NotNull
    private TreePermission buildVersionDelegatee(@NotNull Tree versionableTree) {
        while (!versionableTree.exists()) {
            versionableTree = versionableTree.getParent();
        }
        if (versionableTree.isRoot()) {
            return this.createRootPermission(versionableTree);
        }
        TreeType type = this.typeProvider.getType(versionableTree);
        switch (type) {
            case HIDDEN: {
                return TreePermission.ALL;
            }
            case INTERNAL: {
                return InternalTreePermission.INSTANCE;
            }
        }
        return new TreePermissionImpl(versionableTree, type, this.buildParentPermission(versionableTree));
    }

    @NotNull
    private TreePermission buildParentPermission(@NotNull Tree tree) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        while (!tree.isRoot()) {
            tree = tree.getParent();
            trees.add(0, tree);
        }
        TreePermission pp = TreePermission.EMPTY;
        TreeType type = TreeType.DEFAULT;
        for (Tree tr : trees) {
            type = this.typeProvider.getType(tr, type);
            pp = new TreePermissionImpl(tr, type, pp);
        }
        return pp;
    }

    @Override
    public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        TreeType type = this.typeProvider.getType(tree);
        switch (type) {
            case HIDDEN: {
                return true;
            }
            case VERSION: {
                Tree versionTree = this.getEvaluationTree(tree);
                if (versionTree == null) {
                    return false;
                }
                if (versionTree.exists()) {
                    return this.internalIsGranted(versionTree, property, permissions);
                }
                String path = versionTree.getPath();
                if (property != null) {
                    path = PathUtils.concat(path, property.getName());
                }
                return this.isGranted(path, permissions);
            }
            case INTERNAL: {
                return false;
            }
        }
        return this.internalIsGranted(tree, property, permissions);
    }

    @Override
    public boolean isGranted(@NotNull String path, long permissions) {
        EntryPredicate predicate = EntryPredicate.create(path, Permissions.respectParentPermissions(permissions));
        return this.hasPermissions(this.getEntryIterator(predicate), predicate, permissions, path);
    }

    @Override
    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.bitsProvider.getPrivilegeNames(this.internalGetPrivileges(tree));
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.internalGetPrivileges(tree).includes(this.bitsProvider.getBits(privilegeNames));
    }

    private boolean internalIsGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        EntryPredicate predicate = EntryPredicate.create(tree, property, Permissions.respectParentPermissions(permissions));
        return this.hasPermissions(this.getEntryIterator(predicate), predicate, permissions, tree.getPath());
    }

    private boolean hasPermissions(@NotNull Iterator<PermissionEntry> entries, @NotNull EntryPredicate predicate, long permissions, @Nullable String path) {
        String parentPath;
        PrivilegeBits parentDenyBits;
        PrivilegeBits parentAllowBits;
        boolean isReadable;
        boolean bl = isReadable = Permissions.diff(3L, permissions) != 3L && this.readPolicy.isReadablePath(path, false);
        if (!entries.hasNext() && !isReadable) {
            return false;
        }
        boolean respectParent = path != null && Permissions.respectParentPermissions(permissions);
        long allows = isReadable ? 3L : 0L;
        long denies = 0L;
        PrivilegeBits allowBits = PrivilegeBits.getInstance();
        if (isReadable) {
            allowBits.add(this.bitsProvider.getBits("jcr:read"));
        }
        PrivilegeBits denyBits = PrivilegeBits.getInstance();
        if (respectParent) {
            parentAllowBits = PrivilegeBits.getInstance();
            parentDenyBits = PrivilegeBits.getInstance();
            parentPath = PermissionUtil.getParentPathOrNull(path);
        } else {
            parentAllowBits = PrivilegeBits.EMPTY;
            parentDenyBits = PrivilegeBits.EMPTY;
            parentPath = null;
        }
        while (entries.hasNext()) {
            long dp;
            boolean matchesParent;
            PermissionEntry entry = entries.next();
            if (respectParent && parentPath != null && (matchesParent = entry.matchesParent(parentPath))) {
                if (entry.isAllow) {
                    parentAllowBits.addDifference(entry.privilegeBits, parentDenyBits);
                } else {
                    parentDenyBits.addDifference(entry.privilegeBits, parentAllowBits);
                }
            }
            if (entry.isAllow) {
                long ap;
                if (!respectParent || predicate.apply(entry, false)) {
                    allowBits.addDifference(entry.privilegeBits, denyBits);
                }
                if (((allows |= Permissions.diff(ap = PrivilegeBits.calculatePermissions(allowBits, parentAllowBits, true), denies)) | permissions ^ 0xFFFFFFFFFFFFFFFFL) != -1L) continue;
                return true;
            }
            if (!respectParent || predicate.apply(entry, false)) {
                denyBits.addDifference(entry.privilegeBits, allowBits);
            }
            if (!Permissions.includes(denies |= Permissions.diff(dp = PrivilegeBits.calculatePermissions(denyBits, parentDenyBits, false), allows), permissions)) continue;
            return false;
        }
        return (allows | permissions ^ 0xFFFFFFFFFFFFFFFFL) == -1L;
    }

    @NotNull
    private PrivilegeBits internalGetPrivileges(@Nullable Tree tree) {
        TreeType type = tree == null ? TreeType.DEFAULT : this.typeProvider.getType(tree);
        switch (type) {
            case HIDDEN: {
                return PrivilegeBits.EMPTY;
            }
            case VERSION: {
                Tree versionTree = this.getEvaluationTree(tree);
                if (versionTree == null || !versionTree.exists()) {
                    return PrivilegeBits.EMPTY;
                }
                return this.getPrivilegeBits(versionTree);
            }
            case INTERNAL: {
                return PrivilegeBits.EMPTY;
            }
        }
        return this.getPrivilegeBits(tree);
    }

    @NotNull
    private PrivilegeBits getPrivilegeBits(@Nullable Tree tree) {
        EntryPredicate pred = tree == null ? EntryPredicate.create() : EntryPredicate.create(tree, null, false);
        Iterator<PermissionEntry> entries = this.getEntryIterator(pred);
        PrivilegeBits allowBits = PrivilegeBits.getInstance();
        PrivilegeBits denyBits = PrivilegeBits.getInstance();
        while (entries.hasNext()) {
            PermissionEntry entry = entries.next();
            if (entry.isAllow) {
                allowBits.addDifference(entry.privilegeBits, denyBits);
                continue;
            }
            denyBits.addDifference(entry.privilegeBits, allowBits);
        }
        if (tree != null && this.readPolicy.isReadableTree(tree, false)) {
            allowBits.add(this.bitsProvider.getBits("jcr:read"));
        }
        return allowBits;
    }

    @NotNull
    private Iterator<PermissionEntry> getEntryIterator(@NotNull EntryPredicate predicate) {
        if (this.userStore != null && this.groupStore != null) {
            Iterator<PermissionEntry> userEntries = this.userStore.getEntryIterator(predicate);
            Iterator<PermissionEntry> groupEntries = this.groupStore.getEntryIterator(predicate);
            return Iterators.concat(userEntries, groupEntries);
        }
        if (this.userStore != null) {
            return this.userStore.getEntryIterator(predicate);
        }
        if (this.groupStore != null) {
            return this.groupStore.getEntryIterator(predicate);
        }
        return Collections.emptyIterator();
    }

    @Nullable
    private Tree getEvaluationTree(@NotNull Tree versionStoreTree) {
        if (ReadOnlyVersionManager.isVersionStoreTree(versionStoreTree)) {
            return versionStoreTree;
        }
        return this.getVersionManager().getVersionable(versionStoreTree, this.workspaceName);
    }

    @NotNull
    private ReadOnlyVersionManager getVersionManager() {
        if (this.versionManager == null) {
            this.versionManager = ReadOnlyVersionManager.getInstance(this.root, NamePathMapper.DEFAULT);
        }
        return this.versionManager;
    }

    private static TreeType getParentType(@NotNull TreePermission parentPermission) {
        if (parentPermission instanceof TreePermissionImpl) {
            return ((TreePermissionImpl)parentPermission).type;
        }
        if (parentPermission == TreePermission.EMPTY) {
            return TreeType.DEFAULT;
        }
        if (parentPermission == InternalTreePermission.INSTANCE) {
            return TreeType.INTERNAL;
        }
        if (parentPermission instanceof VersionTreePermission) {
            return TreeType.VERSION;
        }
        if (parentPermission instanceof RepoPolicyTreePermission) {
            return TreeType.ACCESS_CONTROL;
        }
        throw new IllegalArgumentException("Illegal TreePermission implementation.");
    }

    private TreePermissionImpl createRootPermission(@NotNull Tree rootTree) {
        return new TreePermissionImpl(rootTree, TreeType.DEFAULT, TreePermission.EMPTY);
    }

    private static final class DefaultReadPolicy
    implements ReadPolicy {
        private final String[] readPaths;
        private final String[] altReadPaths;
        private final boolean isDefaultPaths;

        private DefaultReadPolicy(Set<String> readPaths) {
            this.readPaths = readPaths.toArray(new String[0]);
            this.altReadPaths = new String[readPaths.size()];
            int i = 0;
            for (String p : this.readPaths) {
                this.altReadPaths[i++] = p + '/';
            }
            this.isDefaultPaths = readPaths.size() == PermissionConstants.DEFAULT_READ_PATHS.size() && readPaths.containsAll(PermissionConstants.DEFAULT_READ_PATHS);
        }

        @Override
        public boolean isReadableTree(@NotNull Tree tree, @Nullable TreePermissionImpl parent) {
            if (parent != null) {
                if (parent.isReadableTree) {
                    return true;
                }
                if (!this.isDefaultPaths || parent.tree.getName().equals("jcr:system")) {
                    return this.isReadableTree(tree, true);
                }
                return false;
            }
            return this.isReadableTree(tree, true);
        }

        @Override
        public boolean isReadableTree(@NotNull Tree tree, boolean exactMatch) {
            String targetPath = tree.getPath();
            for (String path : this.readPaths) {
                if (!targetPath.equals(path)) continue;
                return true;
            }
            if (!exactMatch) {
                for (String path : this.altReadPaths) {
                    if (!targetPath.startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isReadablePath(@Nullable String treePath, boolean exactMatch) {
            if (treePath != null) {
                for (String path : this.readPaths) {
                    if (!treePath.equals(path)) continue;
                    return true;
                }
                if (!exactMatch) {
                    for (String path : this.altReadPaths) {
                        if (!treePath.startsWith(path)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class EmptyReadPolicy
    implements ReadPolicy {
        private static final ReadPolicy INSTANCE = new EmptyReadPolicy();

        private EmptyReadPolicy() {
        }

        @Override
        public boolean isReadableTree(@NotNull Tree tree, @Nullable TreePermissionImpl parent) {
            return false;
        }

        @Override
        public boolean isReadableTree(@NotNull Tree tree, boolean exactMatch) {
            return false;
        }

        @Override
        public boolean isReadablePath(@Nullable String treePath, boolean exactMatch) {
            return false;
        }
    }

    private static interface ReadPolicy {
        public boolean isReadableTree(@NotNull Tree var1, @Nullable TreePermissionImpl var2);

        public boolean isReadableTree(@NotNull Tree var1, boolean var2);

        public boolean isReadablePath(@Nullable String var1, boolean var2);
    }

    private static final class LazyIterator
    extends AbstractLazyIterator<PermissionEntry> {
        private final TreePermissionImpl treePermission;
        private final boolean isUser;
        private final EntryPredicate predicate;
        private Iterator<PermissionEntry> nextEntries = Collections.emptyIterator();
        private TreePermissionImpl tp;

        private LazyIterator(@NotNull TreePermissionImpl treePermission, boolean isUser, @NotNull EntryPredicate predicate) {
            this.treePermission = treePermission;
            this.isUser = isUser;
            this.predicate = predicate;
            this.tp = treePermission;
        }

        @Override
        protected PermissionEntry getNext() {
            PermissionEntry next = null;
            while (next == null) {
                if (this.nextEntries.hasNext()) {
                    PermissionEntry pe = this.nextEntries.next();
                    if (this.predicate.apply(pe)) {
                        next = pe;
                        continue;
                    }
                    this.treePermission.skipped = true;
                    continue;
                }
                if (this.tp == null) break;
                this.nextEntries = this.isUser ? this.tp.getUserEntries() : this.tp.getGroupEntries();
                this.tp = this.tp.parent;
            }
            return next;
        }
    }

    private final class TreePermissionImpl
    implements TreePermission {
        private final Tree tree;
        private final TreePermissionImpl parent;
        private final TreeType type;
        private final boolean isReadableTree;
        private Collection<PermissionEntry> userEntries;
        private Collection<PermissionEntry> groupEntries;
        private boolean skipped;
        private ReadStatus readStatus;

        private TreePermissionImpl(Tree tree, TreeType type, TreePermission parentPermission) {
            this.tree = tree;
            this.type = type;
            this.parent = parentPermission instanceof TreePermissionImpl ? (TreePermissionImpl)parentPermission : null;
            this.isReadableTree = CompiledPermissionImpl.this.readPolicy.isReadableTree(tree, this.parent);
        }

        @Override
        @NotNull
        public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
            Tree childTree = CompiledPermissionImpl.this.providerCtx.getTreeProvider().createReadOnlyTree(this.tree, childName, childState);
            return CompiledPermissionImpl.this.getTreePermission(childTree, CompiledPermissionImpl.this.typeProvider.getType(childTree, this.type), this);
        }

        @Override
        public boolean canRead() {
            boolean isAcTree = this.isAcTree();
            if (!isAcTree && this.isReadableTree) {
                return true;
            }
            if (this.readStatus == null) {
                this.readStatus = ReadStatus.DENY_THIS;
                long permission = isAcTree ? 128L : 1L;
                PrivilegeBits requiredBits = (PrivilegeBits)READ_BITS.get(permission);
                Iterator<PermissionEntry> it = this.getIterator(null, permission);
                while (it.hasNext()) {
                    PermissionEntry entry = it.next();
                    if (entry.privilegeBits.includes(requiredBits)) {
                        this.readStatus = ReadStatus.create(entry, permission, this.skipped);
                        break;
                    }
                    if (permission != 1L || !entry.privilegeBits.includes((PrivilegeBits)READ_BITS.get(2L))) continue;
                    this.skipped = true;
                }
            }
            return this.readStatus.allowsThis();
        }

        @Override
        public boolean canRead(@NotNull PropertyState property) {
            boolean isAcTree = this.isAcTree();
            if (!isAcTree && this.isReadableTree) {
                return true;
            }
            if (this.readStatus != null && this.readStatus.allowsProperties()) {
                return true;
            }
            long permission = isAcTree ? 128L : 2L;
            Iterator<PermissionEntry> it = this.getIterator(property, permission);
            while (it.hasNext()) {
                PermissionEntry entry = it.next();
                if (!entry.privilegeBits.includes((PrivilegeBits)READ_BITS.get(permission))) continue;
                return entry.isAllow;
            }
            return false;
        }

        @Override
        public boolean canReadAll() {
            return this.readStatus != null && this.readStatus.allowsAll();
        }

        @Override
        public boolean canReadProperties() {
            return this.readStatus != null && this.readStatus.allowsProperties();
        }

        @Override
        public boolean isGranted(long permissions) {
            EntryPredicate predicate = EntryPredicate.create(this.tree, null, Permissions.respectParentPermissions(permissions));
            Iterator<PermissionEntry> it = this.getIterator(predicate);
            return CompiledPermissionImpl.this.hasPermissions(it, predicate, permissions, this.tree.getPath());
        }

        @Override
        public boolean isGranted(long permissions, @NotNull PropertyState property) {
            EntryPredicate predicate = EntryPredicate.create(this.tree, property, Permissions.respectParentPermissions(permissions));
            Iterator<PermissionEntry> it = this.getIterator(predicate);
            return CompiledPermissionImpl.this.hasPermissions(it, predicate, permissions, this.tree.getPath());
        }

        private Iterator<PermissionEntry> getIterator(@Nullable PropertyState property, long permissions) {
            EntryPredicate predicate = EntryPredicate.create(this.tree, property, Permissions.respectParentPermissions(permissions));
            return this.getIterator(predicate);
        }

        private Iterator<PermissionEntry> getIterator(@NotNull EntryPredicate predicate) {
            if (CompiledPermissionImpl.this.userStore != null && CompiledPermissionImpl.this.groupStore != null) {
                return Iterators.concat(new LazyIterator(this, true, predicate), new LazyIterator(this, false, predicate));
            }
            if (CompiledPermissionImpl.this.userStore != null) {
                return new LazyIterator(this, true, predicate);
            }
            if (CompiledPermissionImpl.this.groupStore != null) {
                return new LazyIterator(this, false, predicate);
            }
            return Collections.emptyIterator();
        }

        private Iterator<PermissionEntry> getUserEntries() {
            if (this.userEntries == null) {
                this.userEntries = CompiledPermissionImpl.this.userStore != null ? CompiledPermissionImpl.this.userStore.getEntries(this.tree) : Collections.emptyList();
            }
            return this.userEntries.iterator();
        }

        private Iterator<PermissionEntry> getGroupEntries() {
            if (this.groupEntries == null) {
                this.groupEntries = CompiledPermissionImpl.this.groupStore != null ? CompiledPermissionImpl.this.groupStore.getEntries(this.tree) : Collections.emptyList();
            }
            return this.groupEntries.iterator();
        }

        private boolean isAcTree() {
            return this.type == TreeType.ACCESS_CONTROL;
        }
    }
}

