/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.resourcemodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.validation.impl.model.ChildResourceImpl;
import org.apache.sling.validation.impl.model.ResourcePropertyBuilder;
import org.apache.sling.validation.impl.model.ValidationModelBuilder;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidationModel;
import org.apache.sling.validation.model.spi.ValidationModelProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ValidationModelProvider.class})
public class ResourceValidationModelProviderImpl
implements ValidationModelProvider,
EventHandler {
    static final String MODEL_XPATH_QUERY = "/jcr:root%s/*[@sling:resourceType=\"sling/validation/model\" and @validatingResourceType=\"%s\"]";
    static final String[] TOPICS = new String[]{"org/apache/sling/api/resource/Resource/REMOVED", "org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/ADDED"};
    @Nonnull
    public static final String NAME_REGEX = "nameRegex";
    @Nonnull
    public static final String CHILDREN = "children";
    @Nonnull
    public static final String VALIDATOR_ARGUMENTS = "validatorArguments";
    @Nonnull
    public static final String VALIDATORS = "validators";
    @Nonnull
    public static final String OPTIONAL = "optional";
    @Nonnull
    public static final String PROPERTY_MULTIPLE = "propertyMultiple";
    @Nonnull
    public static final String PROPERTIES = "properties";
    @Nonnull
    public static final String VALIDATION_MODEL_RESOURCE_TYPE = "sling/validation/model";
    @Nonnull
    public static final String APPLICABLE_PATHS = "applicablePaths";
    @Nonnull
    public static final String VALIDATING_RESOURCE_TYPE = "validatingResourceType";
    @Nonnull
    public static final String SEVERITY = "severity";
    @Reference
    ResourceResolverFactory rrf = null;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceValidationModelProviderImpl.class);
    private ServiceRegistration<EventHandler> eventHandlerRegistration;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    final Map<String, List<ValidationModel>> validationModelCacheByResourceType = new ConcurrentHashMap<String, List<ValidationModel>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext componentContext) throws LoginException {
        try (ResourceResolver rr = null;){
            rr = this.rrf.getServiceResourceResolver(null);
            StringBuilder sb = new StringBuilder("(");
            String[] searchPaths = rr.getSearchPath();
            if (searchPaths.length > 1) {
                sb.append("|");
            }
            for (String searchPath : searchPaths) {
                sb.append("(path=").append(searchPath + "*").append(")");
            }
            sb.append(")");
            Hashtable<String, Object> eventHandlerProperties = new Hashtable<String, Object>();
            ((Dictionary)eventHandlerProperties).put("event.topics", TOPICS);
            ((Dictionary)eventHandlerProperties).put("event.filter", sb.toString());
            this.eventHandlerRegistration = componentContext.getBundleContext().registerService(EventHandler.class, (Object)this, eventHandlerProperties);
            LOG.debug("Registered event handler for validation models in {}", (Object)sb.toString());
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
            this.eventHandlerRegistration = null;
        }
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        if (path == null) {
            LOG.warn("Received event {}, but could not get the affected path", (Object)event);
            return;
        }
        HashSet<String> resourceTypesToInvalidate = new HashSet<String>();
        switch (event.getTopic()) {
            case "org/apache/sling/api/resource/Resource/REMOVED": {
                for (Map.Entry<String, List<ValidationModel>> validationModelByResourceType : this.validationModelCacheByResourceType.entrySet()) {
                    for (ValidationModel model : validationModelByResourceType.getValue()) {
                        if (!model.getSource().startsWith(path)) continue;
                        LOG.debug("Invalidate validation model at {}, because resource at {} has been removed", (Object)model.getSource(), (Object)path);
                        resourceTypesToInvalidate.add(validationModelByResourceType.getKey());
                    }
                }
                break;
            }
            default: {
                String resourceType = (String)event.getProperty("resourceType");
                if (resourceType == null) {
                    LOG.warn("Received event {}, but could not get the modified/added resource type", (Object)event);
                    return;
                }
                if (VALIDATION_MODEL_RESOURCE_TYPE.equals(resourceType)) {
                    String resourceTypeToInvalidate = null;
                    try {
                        resourceTypeToInvalidate = this.getResourceTypeOfValidationModel(path);
                    }
                    catch (Exception e) {
                        LOG.warn("Could not get covered resource type of newly added validation model at " + path, (Throwable)e);
                    }
                    if (resourceTypeToInvalidate != null) {
                        LOG.debug("Invalidate validation models for resource type {}, because resource at {} provides a new/modified validation model for that type", (Object)resourceType, (Object)path);
                        resourceTypesToInvalidate.add(resourceTypeToInvalidate);
                    } else {
                        LOG.debug("Resource at {} provides a new/modified validation model but could not yet determine for which resource type", (Object)path);
                    }
                }
                for (Map.Entry<String, List<ValidationModel>> validationModelByResourceType : this.validationModelCacheByResourceType.entrySet()) {
                    for (ValidationModel model : validationModelByResourceType.getValue()) {
                        if (!path.startsWith(model.getSource())) continue;
                        LOG.debug("Invalidate validation model at {}, because resource below (at {}) has been modified", (Object)model.getSource(), (Object)path);
                        resourceTypesToInvalidate.add(validationModelByResourceType.getKey());
                    }
                }
            }
        }
        for (String resourceTypeToInvalidate : resourceTypesToInvalidate) {
            this.validationModelCacheByResourceType.remove(resourceTypeToInvalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceTypeOfValidationModel(@Nonnull String path) throws LoginException {
        try (ResourceResolver resourceResolver = null;){
            resourceResolver = this.rrf.getServiceResourceResolver(null);
            Resource modelResource = resourceResolver.getResource(path);
            if (modelResource == null) {
                throw new IllegalStateException("Can no longer access resource at " + path);
            }
            ValueMap properties = (ValueMap)modelResource.adaptTo(ValueMap.class);
            if (properties == null) {
                throw new IllegalStateException("Could not adapt resource at " + path + " to a ValueMap");
            }
            String string = (String)properties.get(VALIDATING_RESOURCE_TYPE, String.class);
            return string;
        }
    }

    @Nonnull
    public List<ValidationModel> getValidationModels(@Nonnull String relativeResourceType) {
        List<ValidationModel> cacheEntry = this.validationModelCacheByResourceType.get(relativeResourceType);
        if (cacheEntry == null) {
            cacheEntry = this.doGetModels(relativeResourceType);
            this.validationModelCacheByResourceType.put(relativeResourceType, cacheEntry);
        } else {
            LOG.debug("Found entry in cache for resource type {}", (Object)relativeResourceType);
        }
        return cacheEntry;
    }

    @Nonnull
    private List<ValidationModel> doGetModels(@Nonnull String relativeResourceType) {
        ArrayList<ValidationModel> validationModels = new ArrayList<ValidationModel>();
        try (ResourceResolver resourceResolver = null;){
            String[] searchPaths;
            resourceResolver = this.rrf.getServiceResourceResolver(null);
            for (String searchPath : searchPaths = resourceResolver.getSearchPath()) {
                String queryString = String.format(MODEL_XPATH_QUERY, searchPath, relativeResourceType);
                LOG.debug("Looking for validation models with query '{}'", (Object)queryString);
                Iterator models = resourceResolver.findResources(queryString, "xpath");
                while (models.hasNext()) {
                    Resource model = (Resource)models.next();
                    LOG.debug("Found validation model resource {}.", (Object)model.getPath());
                    String resourcePath = model.getPath();
                    try {
                        ValidationModelBuilder modelBuilder = new ValidationModelBuilder();
                        ValueMap validationModelProperties = model.getValueMap();
                        modelBuilder.addApplicablePaths((String[])validationModelProperties.get(APPLICABLE_PATHS, (Object)new String[0]));
                        Resource propertiesResource = model.getChild(PROPERTIES);
                        modelBuilder.resourceProperties(this.buildProperties(propertiesResource));
                        modelBuilder.childResources(this.buildChildren(model, model));
                        ValidationModel vm = modelBuilder.build(relativeResourceType, resourcePath);
                        validationModels.add(vm);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Found invalid validation model in '" + resourcePath + "': " + e.getMessage(), e);
                    }
                }
                if (!validationModels.isEmpty()) break;
            }
            ArrayList<ValidationModel> arrayList = validationModels;
            return arrayList;
        }
    }

    @Nonnull
    private List<ResourceProperty> buildProperties(@Nonnull Resource propertiesResource) {
        ArrayList<ResourceProperty> properties = new ArrayList<ResourceProperty>();
        if (propertiesResource != null) {
            for (Resource propertyResource : propertiesResource.getChildren()) {
                Resource validators;
                String nameRegex;
                ResourcePropertyBuilder resourcePropertyBuilder = new ResourcePropertyBuilder();
                String fieldName = propertyResource.getName();
                ValueMap propertyValueMap = propertyResource.getValueMap();
                if (((Boolean)propertyValueMap.get(PROPERTY_MULTIPLE, (Object)false)).booleanValue()) {
                    resourcePropertyBuilder.multiple();
                }
                if (((Boolean)propertyValueMap.get(OPTIONAL, (Object)false)).booleanValue()) {
                    resourcePropertyBuilder.optional();
                }
                if ((nameRegex = (String)propertyValueMap.get(NAME_REGEX, String.class)) != null) {
                    resourcePropertyBuilder.nameRegex(nameRegex);
                }
                if ((validators = propertyResource.getChild(VALIDATORS)) != null) {
                    Iterator validatorsIterator = validators.listChildren();
                    while (validatorsIterator.hasNext()) {
                        Resource validatorResource = (Resource)validatorsIterator.next();
                        ValueMap validatorProperties = (ValueMap)validatorResource.adaptTo(ValueMap.class);
                        if (validatorProperties == null) {
                            throw new IllegalStateException("Could not adapt resource at '" + validatorResource.getPath() + "' to ValueMap");
                        }
                        String validatorId = validatorResource.getName();
                        String[] validatorArguments = (String[])validatorProperties.get(VALIDATOR_ARGUMENTS, String[].class);
                        HashMap<String, Object> validatorArgumentsMap = new HashMap<String, Object>();
                        if (validatorArguments != null) {
                            for (String arg : validatorArguments) {
                                String[] newValue;
                                int positionOfSeparator = arg.indexOf("=");
                                if (positionOfSeparator < 1 || positionOfSeparator >= arg.length() - 1) {
                                    throw new IllegalArgumentException("Invalid validator argument '" + arg + "' found, because it does not follow the format '<key>=<value>'");
                                }
                                String key = arg.substring(0, positionOfSeparator);
                                String[] value = arg.substring(positionOfSeparator + 1);
                                if (validatorArgumentsMap.containsKey(key)) {
                                    Object oldValue = validatorArgumentsMap.get(key);
                                    if (oldValue instanceof String[]) {
                                        String[] oldArray = (String[])oldValue;
                                        int newLength = oldArray.length + 1;
                                        String[] newArray = Arrays.copyOf(oldArray, oldArray.length + 1);
                                        newArray[newLength - 1] = value;
                                        newValue = newArray;
                                    } else {
                                        newValue = new String[]{(String)oldValue, value};
                                    }
                                } else {
                                    newValue = value;
                                }
                                validatorArgumentsMap.put(key, newValue);
                            }
                        }
                        Integer severity = (Integer)validatorProperties.get(SEVERITY, Integer.class);
                        resourcePropertyBuilder.validator(validatorId, severity, validatorArgumentsMap);
                    }
                }
                properties.add(resourcePropertyBuilder.build(fieldName));
            }
        }
        return properties;
    }

    @Nonnull
    private List<ChildResource> buildChildren(@Nonnull Resource modelResource, @Nonnull Resource rootResource) {
        ArrayList<ChildResource> children = new ArrayList<ChildResource>();
        Resource childrenResource = rootResource.getChild(CHILDREN);
        if (childrenResource != null) {
            for (Resource child : childrenResource.getChildren()) {
                ValueMap childrenProperties = (ValueMap)child.adaptTo(ValueMap.class);
                if (childrenProperties == null) {
                    throw new IllegalStateException("Could not adapt resource " + child.getPath() + " to ValueMap");
                }
                String name = child.getName();
                String nameRegex = childrenProperties.containsKey((Object)NAME_REGEX) ? (String)childrenProperties.get(NAME_REGEX, String.class) : null;
                boolean isRequired = (Boolean)childrenProperties.get(OPTIONAL, (Object)false) == false;
                ChildResourceImpl childResource = new ChildResourceImpl(name, nameRegex, isRequired, this.buildProperties(child.getChild(PROPERTIES)), this.buildChildren(modelResource, child));
                children.add(childResource);
            }
        }
        return children;
    }
}

