/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor.filevault;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VaultContentXmlReader {
    private static final DocumentBuilderFactory documentBuilderFactory;
    private final String resourceSuperType;
    private final Path path;
    private final Set<String> requiredResourceTypes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VaultContentXmlReader(@NotNull Path path) throws IOException {
        this.path = path;
        this.requiredResourceTypes = new HashSet<String>();
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            String requiredResourceTypesRawValue;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            NodeList nodeList = document.getElementsByTagNameNS(NameConstants.JCR_ROOT.getNamespaceURI(), NameConstants.JCR_ROOT.getLocalName());
            if (nodeList.getLength() != 1 || !nodeList.item(0).equals(document.getDocumentElement())) throw new IllegalArgumentException(String.format("Path %s does not seem to provide a Docview format - https://jackrabbit.apache.org/filevault/docview.html.", path));
            String resourceSuperTypeRawValue = document.getDocumentElement().getAttributeNS("http://sling.apache.org/jcr/sling/1.0", "resourceSuperType");
            if (StringUtils.isNotEmpty((CharSequence)resourceSuperTypeRawValue)) {
                DocViewProperty resourceSuperTypeDocViewProperty = DocViewProperty.parse((String)"sling:resourceSuperType", (String)resourceSuperTypeRawValue);
                if (resourceSuperTypeDocViewProperty.type != 1 && resourceSuperTypeDocViewProperty.type != 0 || resourceSuperTypeDocViewProperty.isMulti) throw new IllegalArgumentException(String.format("Invalid %s property value (%s) in file %s.", "sling:resourceSuperType", resourceSuperTypeRawValue, path));
                this.resourceSuperType = resourceSuperTypeDocViewProperty.values[0];
            } else {
                this.resourceSuperType = null;
            }
            if (!StringUtils.isNotEmpty((CharSequence)(requiredResourceTypesRawValue = document.getDocumentElement().getAttributeNS("http://sling.apache.org/jcr/sling/1.0", "requiredResourceTypes")))) return;
            DocViewProperty requiredResourceTypesDocViewProperty = DocViewProperty.parse((String)"sling:requiredResourceTypes", (String)requiredResourceTypesRawValue);
            if (!requiredResourceTypesDocViewProperty.isMulti || requiredResourceTypesDocViewProperty.type != 1 && requiredResourceTypesDocViewProperty.type != 0) throw new IllegalArgumentException(String.format("Invalid %s property value (%s) in file %s.", "sling:requiredResourceTypes", requiredResourceTypesRawValue, path));
            this.requiredResourceTypes.addAll(Arrays.asList(requiredResourceTypesDocViewProperty.values));
            return;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    @NotNull
    public Optional<String> getSlingResourceSuperType() {
        return Optional.ofNullable(this.resourceSuperType);
    }

    @NotNull
    public Set<String> getSlingRequiredResourceTypes() {
        return Collections.unmodifiableSet(this.requiredResourceTypes);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.resourceSuperType, this.requiredResourceTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VaultContentXmlReader) {
            VaultContentXmlReader other = (VaultContentXmlReader)obj;
            return Objects.equals(this.path, other.path) && Objects.equals(this.resourceSuperType, other.resourceSuperType) && Objects.equals(this.requiredResourceTypes, other.requiredResourceTypes);
        }
        return false;
    }

    static {
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setNamespaceAware(true);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot disable DTD features.", e);
        }
    }
}

