/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SeedStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.ProductiveByStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.EdgeLabelVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReservedKeysVerificationStrategy;

public class TraversalStrategyVisitor
extends DefaultGremlinBaseVisitor<TraversalStrategy> {
    protected final GremlinAntlrToJava antlr;

    public TraversalStrategyVisitor(GremlinAntlrToJava antlrToJava) {
        this.antlr = antlrToJava;
    }

    @Override
    public TraversalStrategy visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            String strategyName = ctx.getChild(0).getText();
            if (strategyName.equals(ReadOnlyStrategy.class.getSimpleName())) {
                return ReadOnlyStrategy.instance();
            }
            if (strategyName.equals(ProductiveByStrategy.class.getSimpleName())) {
                return ProductiveByStrategy.instance();
            }
        } else if (ctx.getChild(0).getText().equals("new")) {
            String strategyName = ctx.getChild(1).getText();
            if (strategyName.equals(PartitionStrategy.class.getSimpleName())) {
                return this.getPartitionStrategy(ctx.traversalStrategyArgs_PartitionStrategy());
            }
            if (strategyName.equals(ReservedKeysVerificationStrategy.class.getSimpleName())) {
                return this.getReservedKeysVerificationStrategy(ctx.traversalStrategyArgs_ReservedKeysVerificationStrategy());
            }
            if (strategyName.equals(EdgeLabelVerificationStrategy.class.getSimpleName())) {
                return this.getEdgeLabelVerificationStrategy(ctx.traversalStrategyArgs_EdgeLabelVerificationStrategy());
            }
            if (strategyName.equals(SubgraphStrategy.class.getSimpleName())) {
                return this.getSubgraphStrategy(ctx.traversalStrategyArgs_SubgraphStrategy());
            }
            if (strategyName.equals(SeedStrategy.class.getSimpleName())) {
                return SeedStrategy.build().seed(this.antlr.argumentVisitor.parseNumber(ctx.integerArgument()).longValue()).create();
            }
            if (strategyName.equals(ProductiveByStrategy.class.getSimpleName())) {
                return this.getProductiveByStrategy(ctx.traversalStrategyArgs_ProductiveByStrategy());
            }
        }
        throw new IllegalStateException("Unexpected TraversalStrategy specification - " + ctx.getText());
    }

    private EdgeLabelVerificationStrategy getEdgeLabelVerificationStrategy(List<GremlinParser.TraversalStrategyArgs_EdgeLabelVerificationStrategyContext> ctxs) {
        if (null == ctxs || ctxs.isEmpty()) {
            return EdgeLabelVerificationStrategy.build().create();
        }
        EdgeLabelVerificationStrategy.Builder builder = EdgeLabelVerificationStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "logWarning": {
                    builder.logWarning(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                    break;
                }
                case "throwException": {
                    builder.throwException(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                }
            }
        });
        return builder.create();
    }

    private ReservedKeysVerificationStrategy getReservedKeysVerificationStrategy(List<GremlinParser.TraversalStrategyArgs_ReservedKeysVerificationStrategyContext> ctxs) {
        if (null == ctxs || ctxs.isEmpty()) {
            return ReservedKeysVerificationStrategy.build().create();
        }
        ReservedKeysVerificationStrategy.Builder builder = ReservedKeysVerificationStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "logWarning": {
                    builder.logWarning(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                    break;
                }
                case "throwException": {
                    builder.throwException(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                    break;
                }
                case "keys": {
                    builder.reservedKeys(new HashSet<String>(Arrays.asList(this.antlr.genericVisitor.parseStringList(ctx.stringLiteralList()))));
                }
            }
        });
        return builder.create();
    }

    private PartitionStrategy getPartitionStrategy(List<GremlinParser.TraversalStrategyArgs_PartitionStrategyContext> ctxs) {
        PartitionStrategy.Builder builder = PartitionStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "includeMetaProperties": {
                    builder.includeMetaProperties(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                    break;
                }
                case "readPartitions": {
                    builder.readPartitions(Arrays.asList(this.antlr.genericVisitor.parseStringList(ctx.stringLiteralList())));
                    break;
                }
                case "writePartition": {
                    builder.writePartition(this.antlr.argumentVisitor.parseString(ctx.stringArgument()));
                    break;
                }
                case "partitionKey": {
                    builder.partitionKey(this.antlr.argumentVisitor.parseString(ctx.stringArgument()));
                }
            }
        });
        return builder.create();
    }

    private SubgraphStrategy getSubgraphStrategy(List<GremlinParser.TraversalStrategyArgs_SubgraphStrategyContext> ctxs) {
        SubgraphStrategy.Builder builder = SubgraphStrategy.build();
        ctxs.forEach(ctx -> {
            switch (ctx.getChild(0).getText()) {
                case "vertices": {
                    builder.vertices(this.antlr.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "edges": {
                    builder.edges(this.antlr.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "vertexProperties": {
                    builder.vertexProperties(this.antlr.tvisitor.visitNestedTraversal(ctx.nestedTraversal()));
                    break;
                }
                case "checkAdjacentVertices": {
                    builder.checkAdjacentVertices(this.antlr.argumentVisitor.parseBoolean(ctx.booleanArgument()));
                }
            }
        });
        return builder.create();
    }

    private ProductiveByStrategy getProductiveByStrategy(GremlinParser.TraversalStrategyArgs_ProductiveByStrategyContext ctx) {
        ProductiveByStrategy.Builder builder = ProductiveByStrategy.build();
        builder.productiveKeys(Arrays.asList(this.antlr.genericVisitor.parseStringList(ctx.stringLiteralList())));
        return builder.create();
    }
}

