/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.HtmlDocWriter;
import com.sun.tools.doclets.IndexBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import xalanjdoc.AllClassesFrameWriter;
import xalanjdoc.ClassUseMapper;
import xalanjdoc.ClassWriter;
import xalanjdoc.ConfigurationStandard;
import xalanjdoc.DeprecatedListWriter;
import xalanjdoc.FrameOutputWriter;
import xalanjdoc.HelpWriter;
import xalanjdoc.PackageFrameWriter;
import xalanjdoc.PackageIndexFrameWriter;
import xalanjdoc.PackageIndexWriter;
import xalanjdoc.PackageListWriter;
import xalanjdoc.PackageTreeWriter;
import xalanjdoc.PackageWriter;
import xalanjdoc.PackagesFileWriter;
import xalanjdoc.SerializedFormWriter;
import xalanjdoc.SingleIndexWriter;
import xalanjdoc.SplitIndexWriter;
import xalanjdoc.StylesheetWriter;
import xalanjdoc.TreeWriter;

public class Standard {
    protected String classFileName(ClassDoc cd) {
        return String.valueOf(cd.qualifiedName()) + ".html";
    }

    public static ConfigurationStandard configuration() {
        if (HtmlDocWriter.configuration == null) {
            HtmlDocWriter.configuration = new ConfigurationStandard();
        }
        return (ConfigurationStandard)HtmlDocWriter.configuration;
    }

    public static void copyFile(File destfile, File srcfile) throws DocletAbortException, IOException {
        byte[] bytearr = new byte[512];
        int len = 0;
        FileInputStream input = new FileInputStream(srcfile);
        FileOutputStream output = new FileOutputStream(destfile);
        try {
            try {
                while ((len = input.read(bytearr)) != -1) {
                    output.write(bytearr, 0, len);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DocletAbortException();
            }
            catch (SecurityException securityException) {
                throw new DocletAbortException();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            input.close();
            output.close();
            throw throwable;
        }
        input.close();
        output.close();
    }

    protected void generateClassCycle(ClassDoc[] arr, ClassTree classtree, boolean nopackage) throws DocletAbortException {
        Arrays.sort(arr);
        int i = 0;
        while (i < arr.length) {
            if (!Standard.configuration().nodeprecated || arr[i].tags("deprecated").length <= 0) {
                ClassDoc prev = i == 0 ? null : arr[i - 1];
                ClassDoc curr = arr[i];
                ClassDoc next = i + 1 == arr.length ? null : arr[i + 1];
                ClassWriter.generate(curr, prev, next, classtree, nopackage);
            }
            ++i;
        }
    }

    protected void generateClassFiles(RootDoc root, ClassTree classtree) throws DocletAbortException {
        ClassDoc[] classes = root.specifiedClasses();
        ArrayList<ClassDoc> incl = new ArrayList<ClassDoc>();
        int i = 0;
        while (i < classes.length) {
            ClassDoc cd = classes[i];
            if (cd.isIncluded()) {
                incl.add(cd);
            }
            ++i;
        }
        ClassDoc[] inclClasses = new ClassDoc[incl.size()];
        int i2 = 0;
        while (i2 < inclClasses.length) {
            inclClasses[i2] = (ClassDoc)incl.get(i2);
            ++i2;
        }
        this.generateClassCycle(inclClasses, classtree, true);
        PackageDoc[] packages = Standard.configuration().packages;
        int i3 = 0;
        while (i3 < packages.length) {
            PackageDoc pkg = packages[i3];
            this.generateClassCycle(pkg.interfaces(), classtree, false);
            this.generateClassCycle(pkg.ordinaryClasses(), classtree, false);
            this.generateClassCycle(pkg.exceptions(), classtree, false);
            this.generateClassCycle(pkg.errors(), classtree, false);
            ++i3;
        }
    }

    public static int optionLength(String option) {
        return Standard.configuration().optionLength(option);
    }

    protected void performCopy(String configdestdir, String filename) throws DocletAbortException {
        try {
            String destdir;
            String string = destdir = configdestdir.length() > 0 ? (destdir = String.valueOf(configdestdir) + File.separatorChar) : "";
            if (filename.length() > 0) {
                File helpstylefile = new File(filename);
                String parent = helpstylefile.getParent();
                String helpstylefilename = parent == null ? filename : filename.substring(parent.length() + 1);
                File desthelpfile = new File(String.valueOf(destdir) + helpstylefilename);
                if (!desthelpfile.getCanonicalPath().equals(helpstylefile.getCanonicalPath())) {
                    Standard.configuration();
                    ConfigurationStandard.standardmessage.notice("doclet.Copying_File_0_To_File_1", helpstylefile.toString(), desthelpfile.toString());
                    Standard.copyFile(desthelpfile, helpstylefile);
                }
            }
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.perform_copy_exception_encountered", exc.toString());
            throw new DocletAbortException();
        }
    }

    public static boolean start(RootDoc root) throws IOException {
        try {
            Standard.configuration().setOptions(root);
            new Standard().startGeneration(root);
        }
        catch (DocletAbortException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    protected void startGeneration(RootDoc root) throws DocletAbortException {
        if (root.classes().length == 0) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.notice("doclet.No_Public_Classes_To_Document");
            return;
        }
        String configdestdir = Standard.configuration().destdirname;
        String confighelpfile = Standard.configuration().helpfile;
        String configstylefile = Standard.configuration().stylesheetfile;
        boolean nodeprecated = Standard.configuration().nodeprecated;
        this.performCopy(configdestdir, confighelpfile);
        this.performCopy(configdestdir, configstylefile);
        ClassTree classtree = new ClassTree(root, nodeprecated);
        if (Standard.configuration().classuse) {
            ClassUseMapper.generate(root, classtree);
        }
        IndexBuilder indexbuilder = new IndexBuilder(root, nodeprecated);
        PackageDoc[] packages = Standard.configuration().packages;
        if (Standard.configuration().createtree) {
            TreeWriter.generate(classtree);
        }
        if (Standard.configuration().createindex) {
            if (Standard.configuration().splitindex) {
                SplitIndexWriter.generate(indexbuilder);
            } else {
                SingleIndexWriter.generate(indexbuilder);
            }
        }
        if (!Standard.configuration().nodeprecatedlist && !nodeprecated) {
            DeprecatedListWriter.generate(root);
        }
        AllClassesFrameWriter.generate(new IndexBuilder(root, nodeprecated, true));
        FrameOutputWriter.generate();
        PackagesFileWriter.generate();
        if (Standard.configuration().createoverview) {
            PackageIndexWriter.generate(root);
        }
        if (packages.length > 1) {
            PackageIndexFrameWriter.generate();
        }
        int i = 0;
        while (i < packages.length) {
            PackageDoc prev = i == 0 ? null : packages[i - 1];
            PackageDoc packagedoc = packages[i];
            PackageDoc next = i + 1 == packages.length ? null : packages[i + 1];
            PackageWriter.generate(packages[i], prev, next);
            PackageTreeWriter.generate(packages[i], prev, next, nodeprecated);
            PackageFrameWriter.generate(packages[i]);
            ++i;
        }
        this.generateClassFiles(root, classtree);
        SerializedFormWriter.generate(root);
        PackageListWriter.generate(root);
        HelpWriter.generate();
        StylesheetWriter.generate();
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) throws IOException {
        return Standard.configuration().validOptions(options, reporter);
    }
}

