%%
%% McCauley 1 A 100 MCM 6955 propeller.
%%
%% Known: Diameter 69in, pitch 55in, diameter of hub ??.
%%        Engine power 100 hp @ 2750 rpm.
%%        Max speed 130 knots.
%%

%% JavaProp parameters.
%%
%%   Diameter  D		1.7526 m
%%   Spinner Dia.  Dsp		0.160 m
%%   Speed of Rotation  n	2300 1/min
%%   Velocity  v		49 m/s
%%   Number of Blades  B	2
%%   Power  P			44 kW
%%

JP = [
%v/(nD)	v/(ΩR)	Ct	Cp	Cs	Pc	η	η*	stalled	v	n	Power	Thrust	Torque
%[-]	[-]	[-]	[-]	[-]	[-]	[%]	[%]	[%]	[m/s]	[1/min]	[kW]	[kN]	[kNm]
0.000	0.000	0.083072	0.051711	0.000057	4246951572985.551000	0.01	0.01	36.00 !	0.00	2300	58.809	1.406	244.2
0.100	0.032	0.084503	0.053642	0.179514	136.598824	15.75	34.43	64.00 !	6.72	2300	61.005	1.430	253.3
0.200	0.064	0.084319	0.051458	0.362025	16.379736	32.77	56.14	42.00 !	13.44	2300	58.522	1.427	243.0
0.300	0.095	0.083091	0.050892	0.544241	4.799834	48.98	69.90	25.00	20.15	2300	57.877	1.407	240.3
0.400	0.127	0.080008	0.051165	0.724879	2.035795	62.55	78.93	9.00	26.87	2300	58.188	1.354	241.6
0.500	0.159	0.073879	0.051404	0.905253	1.047202	71.86	85.24	0.00	33.59	2300	58.460	1.251	242.7
0.600	0.191	0.061891	0.048036	1.101127	0.566313	77.30	90.22	0.00	40.31	2300	54.630	1.048	226.8
0.700	0.223	0.047167	0.041179	1.324839	0.305718	80.18	93.95	0.00	47.03	2300	46.831	0.798	194.4
0.800	0.255	0.031761	0.031760	1.594831	0.157960	80.00	96.63	0.00	53.75	2300	36.119	0.538	150.0
0.820	0.261	0.028606	0.029551	1.658440	0.136480	79.38	97.07	0.00	55.09	2300	33.607	0.484	139.5
0.840	0.267	0.025431	0.027232	1.726890	0.116997	78.44	97.48	0.00	56.43	2300	30.969	0.430	128.6
0.860	0.274	0.022232	0.024799	1.801410	0.099283	77.10	97.87	0.00	57.78	2300	28.203	0.376	117.1
0.880	0.280	0.019010	0.022251	1.883700	0.083147	75.18	98.24	0.00	59.12	2300	25.305	0.322	105.1
0.900	0.286	0.015768	0.019589	1.976242	0.068427	72.44	98.59	0.00	60.46	2300	22.278	0.267	92.5
0.920	0.293	0.012506	0.016811	2.082906	0.054975	68.44	98.92	0.00	61.81	2300	19.118	0.212	79.4
0.940	0.299	0.009231	0.013922	2.209964	0.042684	62.32	99.23	0.00	63.15	2300	15.833	0.156	65.7
0.960	0.306	0.005905	0.010887	2.370783	0.031335	52.07	99.52	0.00	64.50	2300	12.381	0.100	51.4
0.980	0.312	0.002565	0.007735	2.591377	0.020929	32.50	99.80	0.00	65.84	2300	8.797	0.043	36.5
1.000	0.318	-0.000790	0.004467	2.951249	0.011374	0.00	99.99	0.00	67.18	2300	5.080	-0.013	21.1
1.020	0.325	-0.004174	0.001065	4.009787	0.002556	0.00	99.99	0.00	68.53	2300	1.211	-0.071	5.0
1.040	0.331	-0.007585	-0.002467	3.456339	-0.005584	0.56	53.90	0.00	69.87	2300	-2.805	-0.128	-11.6
];

C_Thrust1 = [JP(:,1) JP(:,3)];

C_Power1 = [JP(:,1) JP(:,4)];

Efficiency1 = C_Thrust1(:,1) .* C_Thrust1(:,2) ./ C_Power1(:,2);

%% Thrust and Power v.s. advance ratio.

figure();
axis();
plot(C_Thrust1(:,1), C_Thrust1(:,2),
     C_Power1(:,1), C_Power1(:,2));

%% Efficiency v.s. advance ratio.
figure();
axis([0 1 0 1]);
plot(C_Thrust1(:,1), Efficiency1);

Advance = [0:0.05:2.00 100.0];

C_Thrust = [Advance'\
            interp1(C_Thrust1(:,1),C_Thrust1(:,2), Advance, 'extrap')'];

C_Power = [Advance'\
           interp1(C_Power1(:,1),C_Power1(:,2), Advance, 'extrap')'];

figure();
plot(Advance, C_Thrust(:,2), Advance, C_Power(:,2));

%% Efficiency v.s. advance ratio.
Efficiency = C_Thrust(:,1) .* C_Thrust(:,2) ./ C_Power(:,2);
figure();
axis([0 1 0 1]);
plot(C_Thrust(:,1), Efficiency);
