# Custom controls for the A-6
# ------------------------------------------
#
# Updated for EA 6B : BARANGER Emmanuel 04/2023

# RADAR's TC range switch (hard coded range in nautical miles)
# ----------------------------------------------------------
var RADAR_TCrange_sw = func {
  var prop   = props.globals.getNode(arg[0], 1);
  var pr     = prop.getValue();
  var target = props.globals.getNode("/sim/model/instrumentation/RADAR/TCrange", 1);
  if (arg[1] == 1) {
    if (pr == 0) {
      prop.setDoubleValue(1);
      target.setDoubleValue(5);
    } elsif (pr == 1) {
      prop.setDoubleValue(2);
      target.setDoubleValue(1.5);
    }
  } else {
    if (pr == 1) {
      prop.setDoubleValue(0);
      target.setDoubleValue(10);
    } elsif (pr == 2) {
      prop.setDoubleValue(1);
      target.setDoubleValue(5);
    }
  }
}

# TACAN XY switch
# ---------------
var TcXYSwitch = props.globals.getNode("sim/model/controls/instrumentation/tacan/xy-switch", 1);

var tacan_switch_init = func {
  if (sys.TcXY.getValue() == "X") {
    TcXYSwitch.setValue(0);
  } else {
    TcXYSwitch.setValue(1);
  }
}

var tacan_XYtoggle = func {
  var xy_sign   = props.globals.getNode("instrumentation/tacan/frequencies/selected-channel[4]");
  var xy_switch = props.globals.getNode("sim/model/controls/instrumentation/tacan/xy-switch");
  var s         = xy_sign.getValue();
  if ( s == "X" ) {
    xy_sign.setValue("Y");
    xy_switch.setValue(1);
  } else {
    xy_sign.setValue("X");
    xy_switch.setValue(0);
  }
}
