/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/k3s-io/k3s/pkg/apis/k3s.cattle.io/v1"
	scheme "github.com/k3s-io/k3s/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ETCDSnapshotFilesGetter has a method to return a ETCDSnapshotFileInterface.
// A group's client should implement this interface.
type ETCDSnapshotFilesGetter interface {
	ETCDSnapshotFiles() ETCDSnapshotFileInterface
}

// ETCDSnapshotFileInterface has methods to work with ETCDSnapshotFile resources.
type ETCDSnapshotFileInterface interface {
	Create(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.CreateOptions) (*v1.ETCDSnapshotFile, error)
	Update(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (*v1.ETCDSnapshotFile, error)
	UpdateStatus(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (*v1.ETCDSnapshotFile, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ETCDSnapshotFile, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ETCDSnapshotFileList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ETCDSnapshotFile, err error)
	ETCDSnapshotFileExpansion
}

// eTCDSnapshotFiles implements ETCDSnapshotFileInterface
type eTCDSnapshotFiles struct {
	client rest.Interface
}

// newETCDSnapshotFiles returns a ETCDSnapshotFiles
func newETCDSnapshotFiles(c *K3sV1Client) *eTCDSnapshotFiles {
	return &eTCDSnapshotFiles{
		client: c.RESTClient(),
	}
}

// Get takes name of the eTCDSnapshotFile, and returns the corresponding eTCDSnapshotFile object, and an error if there is any.
func (c *eTCDSnapshotFiles) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ETCDSnapshotFile, err error) {
	result = &v1.ETCDSnapshotFile{}
	err = c.client.Get().
		Resource("etcdsnapshotfiles").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ETCDSnapshotFiles that match those selectors.
func (c *eTCDSnapshotFiles) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ETCDSnapshotFileList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ETCDSnapshotFileList{}
	err = c.client.Get().
		Resource("etcdsnapshotfiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested eTCDSnapshotFiles.
func (c *eTCDSnapshotFiles) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("etcdsnapshotfiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a eTCDSnapshotFile and creates it.  Returns the server's representation of the eTCDSnapshotFile, and an error, if there is any.
func (c *eTCDSnapshotFiles) Create(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.CreateOptions) (result *v1.ETCDSnapshotFile, err error) {
	result = &v1.ETCDSnapshotFile{}
	err = c.client.Post().
		Resource("etcdsnapshotfiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(eTCDSnapshotFile).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a eTCDSnapshotFile and updates it. Returns the server's representation of the eTCDSnapshotFile, and an error, if there is any.
func (c *eTCDSnapshotFiles) Update(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (result *v1.ETCDSnapshotFile, err error) {
	result = &v1.ETCDSnapshotFile{}
	err = c.client.Put().
		Resource("etcdsnapshotfiles").
		Name(eTCDSnapshotFile.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(eTCDSnapshotFile).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *eTCDSnapshotFiles) UpdateStatus(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (result *v1.ETCDSnapshotFile, err error) {
	result = &v1.ETCDSnapshotFile{}
	err = c.client.Put().
		Resource("etcdsnapshotfiles").
		Name(eTCDSnapshotFile.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(eTCDSnapshotFile).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the eTCDSnapshotFile and deletes it. Returns an error if one occurs.
func (c *eTCDSnapshotFiles) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("etcdsnapshotfiles").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *eTCDSnapshotFiles) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("etcdsnapshotfiles").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched eTCDSnapshotFile.
func (c *eTCDSnapshotFiles) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ETCDSnapshotFile, err error) {
	result = &v1.ETCDSnapshotFile{}
	err = c.client.Patch(pt).
		Resource("etcdsnapshotfiles").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
