// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigInstrumentationScope()
				CopyOrigInstrumentationScope(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigInstrumentationScope(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigInstrumentationScopeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigInstrumentationScope()
	UnmarshalJSONOrigInstrumentationScope(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigInstrumentationScope(), dest)
}

func TestMarshalAndUnmarshalJSONOrigInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigInstrumentationScope(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigInstrumentationScope()
				UnmarshalJSONOrigInstrumentationScope(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigInstrumentationScope(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigInstrumentationScopeFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigInstrumentationScope()
			require.Error(t, UnmarshalProtoOrigInstrumentationScope(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigInstrumentationScopeUnknown(t *testing.T) {
	dest := NewOrigInstrumentationScope()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigInstrumentationScope(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigInstrumentationScope(), dest)
}

func TestMarshalAndUnmarshalProtoOrigInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigInstrumentationScope(src))
				gotSize := MarshalProtoOrigInstrumentationScope(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigInstrumentationScope()
				require.NoError(t, UnmarshalProtoOrigInstrumentationScope(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigInstrumentationScope(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufInstrumentationScope(t *testing.T) {
	for name, src := range genTestEncodingValuesInstrumentationScope() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigInstrumentationScope(src))
			gotSize := MarshalProtoOrigInstrumentationScope(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.InstrumentationScope{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigInstrumentationScope()
			require.NoError(t, UnmarshalProtoOrigInstrumentationScope(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesInstrumentationScope() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"Name/wrong_wire_type":                   {0xc},
		"Name/missing_value":                     {0xa},
		"Version/wrong_wire_type":                {0x14},
		"Version/missing_value":                  {0x12},
		"Attributes/wrong_wire_type":             {0x1c},
		"Attributes/missing_value":               {0x1a},
		"DroppedAttributesCount/wrong_wire_type": {0x24},
		"DroppedAttributesCount/missing_value":   {0x20},
	}
}

func genTestEncodingValuesInstrumentationScope() map[string]*otlpcommon.InstrumentationScope {
	return map[string]*otlpcommon.InstrumentationScope{
		"empty":                       NewOrigInstrumentationScope(),
		"Name/test":                   {Name: "test_name"},
		"Version/test":                {Version: "test_version"},
		"Attributes/default_and_test": {Attributes: []otlpcommon.KeyValue{{}, *GenTestOrigKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
	}
}
