/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.metrics.mst;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.metrics.AbstractMetric;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSTMetric
extends AbstractMetric {
    public MSTMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        super(nodesToPlace, allNetworks);
    }

    @Override
    public Double compute() {
        double total = 0.0;
        for (PlacementFrame.PlacementNetwork net : this.allNetworks) {
            total += this.compute(net);
        }
        return new Double(total);
    }

    private double compute(PlacementFrame.PlacementNetwork net) {
        TreeSet<Edge> edges = new TreeSet<Edge>();
        for (PlacementFrame.PlacementPort port1 : net.getPortsOnNet()) {
            for (PlacementFrame.PlacementPort port2 : net.getPortsOnNet()) {
                edges.add(new Edge(port1.getPlacementNode(), port2.getPlacementNode(), this.getDistance(port1, port2)));
            }
        }
        KruskalEdges vv = new KruskalEdges();
        for (Edge edge : edges) {
            vv.insertEdge(edge);
        }
        double total = 0.0;
        for (Edge edge : vv.getEdges()) {
            total += edge.getWeight();
        }
        return total;
    }

    private double getDistance(PlacementFrame.PlacementPort port1, PlacementFrame.PlacementPort port2) {
        double deltaX = this.getPlacementX(port1) - this.getPlacementX(port2);
        double deltaY = this.getPlacementY(port1) - this.getPlacementY(port2);
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    @Override
    public String getMetricName() {
        return "MSTMetric";
    }

    private double getPlacementX(PlacementFrame.PlacementPort port) {
        double nodeX = port.getPlacementNode().getPlacementX();
        double portX = port.getRotatedOffX();
        return nodeX + portX;
    }

    private double getPlacementY(PlacementFrame.PlacementPort port) {
        double nodeY = port.getPlacementNode().getPlacementY();
        double portY = port.getRotatedOffY();
        return nodeY + portY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KruskalEdges {
        Vector<HashSet<PlacementFrame.PlacementNode>> vertexGroups = new Vector();
        TreeSet<Edge> kruskalEdges = new TreeSet();

        KruskalEdges() {
        }

        public TreeSet<Edge> getEdges() {
            return this.kruskalEdges;
        }

        HashSet<PlacementFrame.PlacementNode> getVertexGroup(PlacementFrame.PlacementNode vertex) {
            for (HashSet<PlacementFrame.PlacementNode> vertexGroup : this.vertexGroups) {
                if (!vertexGroup.contains(vertex)) continue;
                return vertexGroup;
            }
            return null;
        }

        public void insertEdge(Edge edge) {
            PlacementFrame.PlacementNode vertexA = edge.getVertexA();
            PlacementFrame.PlacementNode vertexB = edge.getVertexB();
            HashSet<PlacementFrame.PlacementNode> vertexGroupA = this.getVertexGroup(vertexA);
            HashSet<PlacementFrame.PlacementNode> vertexGroupB = this.getVertexGroup(vertexB);
            if (vertexGroupA == null) {
                this.kruskalEdges.add(edge);
                if (vertexGroupB == null) {
                    HashSet<PlacementFrame.PlacementNode> htNewVertexGroup = new HashSet<PlacementFrame.PlacementNode>();
                    htNewVertexGroup.add(vertexA);
                    htNewVertexGroup.add(vertexB);
                    this.vertexGroups.add(htNewVertexGroup);
                } else {
                    vertexGroupB.add(vertexA);
                }
            } else if (vertexGroupB == null) {
                vertexGroupA.add(vertexB);
                this.kruskalEdges.add(edge);
            } else if (vertexGroupA != vertexGroupB) {
                vertexGroupA.addAll(vertexGroupB);
                this.vertexGroups.remove(vertexGroupB);
                this.kruskalEdges.add(edge);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Edge
    implements Comparable<Edge> {
        PlacementFrame.PlacementNode vertexA;
        PlacementFrame.PlacementNode vertexB;
        double weight;

        public Edge(PlacementFrame.PlacementNode vertexA, PlacementFrame.PlacementNode vertexB, double weight) {
            this.vertexA = vertexA;
            this.vertexB = vertexB;
            this.weight = weight;
        }

        @Override
        public int compareTo(Edge edge) {
            return this.weight < edge.weight ? -1 : 1;
        }

        public PlacementFrame.PlacementNode getVertexA() {
            return this.vertexA;
        }

        public PlacementFrame.PlacementNode getVertexB() {
            return this.vertexB;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return "(" + this.vertexA + ", " + this.vertexB + ") : Weight = " + this.weight;
        }
    }
}

