/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalSample;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingFrameSample
extends RoutingFrame {
    public RoutingFrame.RoutingParameter maxThreadsParam = new RoutingFrame.RoutingParameter((RoutingFrame)this, "threads", "Number of Threads to use:", 5);
    public RoutingFrame.RoutingParameter happinessParam = new RoutingFrame.RoutingParameter((RoutingFrame)this, "happiness", "Happiness level:", "happy");
    public RoutingFrame.RoutingParameter numericParam = new RoutingFrame.RoutingParameter((RoutingFrame)this, "double", "Floating-point value:", 7.2);
    public RoutingFrame.RoutingParameter booleanParam = new RoutingFrame.RoutingParameter((RoutingFrame)this, "toggle", "Run quickly:", true);

    @Override
    public String getAlgorithmName() {
        return "Simple";
    }

    @Override
    protected void runRouting(Cell cell, List<RoutingFrame.RoutingSegment> segmentsToRoute, List<RoutingFrame.RoutingLayer> allLayers, List<RoutingFrame.RoutingContact> allContacts, List<RoutingFrame.RoutingGeometry> otherBlockages) {
        block0: for (RoutingFrame.RoutingSegment rs : segmentsToRoute) {
            List<RoutingFrame.RoutingLayer> startLayers = rs.getStartLayers();
            List<RoutingFrame.RoutingLayer> finishLayers = rs.getFinishLayers();
            RoutingFrame.RoutingLayer commonLayer = null;
            for (RoutingFrame.RoutingLayer rl1 : startLayers) {
                for (RoutingFrame.RoutingLayer rl2 : finishLayers) {
                    if (rl1 != rl2) continue;
                    commonLayer = rl1;
                    break;
                }
                if (commonLayer == null) continue;
                break;
            }
            if (commonLayer != null) {
                RoutingFrame.RoutePoint p1 = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, rs.getStartEnd().getLocation(), 0);
                rs.addWireEnd(p1);
                RoutingFrame.RoutePoint p2 = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, rs.getFinishEnd().getLocation(), 0);
                rs.addWireEnd(p2);
                RoutingFrame.RouteWire rw = new RoutingFrame.RouteWire(commonLayer, p1, p2, commonLayer.getMinWidth());
                rs.addWire(rw);
                continue;
            }
            for (RoutingFrame.RoutingContact rc : allContacts) {
                RoutingFrame.RoutingLayer startLayer = null;
                RoutingFrame.RoutingLayer finishLayer = null;
                for (RoutingFrame.RoutingLayer rl : startLayers) {
                    if (rl != rc.getFirstLayer() && rl != rc.getSecondLayer()) continue;
                    startLayer = rl;
                    break;
                }
                for (RoutingFrame.RoutingLayer rl : finishLayers) {
                    if (rl != rc.getFirstLayer() && rl != rc.getSecondLayer()) continue;
                    finishLayer = rl;
                    break;
                }
                if (startLayer == null || finishLayer == null) continue;
                RoutingFrame.RoutePoint p1 = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.STARTPOINT, rs.getStartEnd().getLocation(), 0);
                rs.addWireEnd(p1);
                RoutingFrame.RoutePoint p2 = new RoutingFrame.RoutePoint(RoutingFrame.RoutingContact.FINISHPOINT, rs.getFinishEnd().getLocation(), 0);
                rs.addWireEnd(p2);
                Point2D.Double contLoc = new Point2D.Double(rs.getStartEnd().getLocation().getX(), rs.getFinishEnd().getLocation().getY());
                RoutingFrame.RoutePoint pCon = new RoutingFrame.RoutePoint(rc, contLoc, 0);
                rs.addWireEnd(pCon);
                RoutingFrame.RouteWire rw1 = new RoutingFrame.RouteWire(startLayer, p1, pCon, startLayer.getMinWidth());
                rs.addWire(rw1);
                RoutingFrame.RouteWire rw2 = new RoutingFrame.RouteWire(finishLayer, pCon, p2, finishLayer.getMinWidth());
                rs.addWire(rw2);
                continue block0;
            }
        }
    }
}

