/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard;

import com.sun.electric.tool.user.tecEditWizard.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard.TechEditWizardPanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Antenna
extends TechEditWizardPanel {
    private JPanel antenna;
    private JLabel[] metalRatioLabel;
    private JTextField[] metalRatio;
    private JTextField polyRatio;

    public Antenna(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Antenna");
        this.setName("");
        this.antenna = new JPanel();
        this.antenna.setLayout(new GridBagLayout());
        JLabel heading = new JLabel("Antenna Ratios");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.antenna.add((Component)heading, gbc);
        JLabel lab = new JLabel("Poly ratio:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.antenna.add((Component)lab, gbc);
        this.polyRatio = new JTextField();
        this.polyRatio.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.antenna.add((Component)this.polyRatio, gbc);
    }

    public Component getComponent() {
        return this.antenna;
    }

    public String getName() {
        return "Antenna";
    }

    public void init() {
        int i;
        if (this.metalRatioLabel != null) {
            for (i = 0; i < this.metalRatioLabel.length; ++i) {
                this.antenna.remove(this.metalRatioLabel[i]);
            }
        }
        if (this.metalRatio != null) {
            for (i = 0; i < this.metalRatio.length; ++i) {
                this.antenna.remove(this.metalRatio[i]);
            }
        }
        TechEditWizardData data2 = this.wizard.getTechEditData();
        int numMetals = data2.getNumMetalLayers();
        this.metalRatioLabel = new JLabel[numMetals];
        this.metalRatio = new JTextField[numMetals];
        for (int i2 = 0; i2 < numMetals; ++i2) {
            this.metalRatioLabel[i2] = new JLabel("Metal-" + (i2 + 1) + " ratio:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2 + i2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 1, 0);
            this.antenna.add((Component)this.metalRatioLabel[i2], gbc);
            this.metalRatio[i2] = new JTextField();
            this.metalRatio[i2].setText(Double.toString(data2.getMetalAntennaRatio()[i2]));
            this.metalRatio[i2].setColumns(8);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2 + i2;
            gbc.insets = new Insets(4, 0, 1, 2);
            this.antenna.add((Component)this.metalRatio[i2], gbc);
        }
        this.polyRatio.setText(Double.toString(data2.getPolyAntennaRatio()));
    }

    public void term() {
        TechEditWizardData data2 = this.wizard.getTechEditData();
        int numMetals = data2.getNumMetalLayers();
        for (int i = 0; i < numMetals; ++i) {
            data2.setMetalAntennaRatio(i, TextUtils.atof(this.metalRatio[i].getText()));
        }
        data2.setPolyAntennaRatio(TextUtils.atof(this.polyRatio.getText()));
    }
}

