/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config;

import com.sun.electric.util.config.InjectStrategy;
import com.sun.electric.util.config.annotations.Inject;
import com.sun.electric.util.config.model.ParameterEntry;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethodInject<T>
extends InjectStrategy<T> {
    private String factoryMethod;

    public FactoryMethodInject(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    @Override
    public T inject(Class<T> clazz, ParameterEntry ... entries) throws Exception {
        Object instance = null;
        if (entries == null || entries.length == 0) {
            Method factory = clazz.getMethod(this.factoryMethod, new Class[0]);
            instance = factory.invoke(null, new Object[0]);
        } else {
            Method[] methods;
            Object[] paramObjs = new Object[entries.length];
            for (Method method : methods = clazz.getMethods()) {
                Inject inject;
                if (!method.getName().equals(this.factoryMethod) || (inject = method.getAnnotation(Inject.class)) == null) continue;
                this.convertParameterEntires(inject, paramObjs, entries);
                try {
                    Method tmpMethod = clazz.getMethod(this.factoryMethod, this.convertParametersToTypes(method.getParameterTypes(), paramObjs));
                    instance = tmpMethod.invoke(null, paramObjs);
                    break;
                }
                catch (IllegalAccessException ex) {
                    instance = null;
                }
                catch (IllegalArgumentException ex) {
                    instance = null;
                }
                catch (InjectStrategy.ParameterDoesntFit ex) {
                    instance = null;
                }
            }
        }
        return (T)instance;
    }
}

