/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.CatchClause;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpExpVisitor;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;
import java.util.HashSet;

public class FindTailCalls
extends ExpExpVisitor<Expression> {
    public static void findTailCalls(Expression exp, Compilation comp) {
        FindTailCalls visitor = new FindTailCalls();
        visitor.setContext(comp);
        visitor.visit(exp, exp);
    }

    @Override
    protected Expression visitExpression(Expression exp, Expression returnContinuation) {
        return (Expression)super.visitExpression(exp, exp);
    }

    public Expression[] visitExps(Expression[] exps) {
        int n = exps.length;
        for (int i = 0; i < n; ++i) {
            Expression expi = exps[i];
            exps[i] = (Expression)this.visit(expi, expi);
        }
        return exps;
    }

    @Override
    protected Expression visitApplyExp(ApplyExp exp, Expression returnContinuation) {
        boolean inTailContext;
        boolean bl = inTailContext = returnContinuation == this.currentLambda.body;
        if (inTailContext) {
            exp.setTailCall(true);
        }
        exp.context = this.currentLambda;
        LambdaExp lexp = null;
        boolean isAppendValues = false;
        if (exp.func instanceof ReferenceExp) {
            ReferenceExp func = (ReferenceExp)exp.func;
            Declaration binding = Declaration.followAliases(func.binding);
            if (binding != null) {
                Expression value;
                if (!binding.getFlag(2048L)) {
                    exp.nextCall = binding.firstCall;
                    binding.firstCall = exp;
                }
                Compilation comp = this.getCompilation();
                binding.setCanCall();
                if (!comp.mustCompile) {
                    binding.setCanRead();
                }
                if ((value = binding.getValue()) instanceof LambdaExp) {
                    lexp = (LambdaExp)value;
                }
            }
        } else if (exp.func instanceof LambdaExp && !(exp.func instanceof ClassExp)) {
            lexp = (LambdaExp)exp.func;
            this.visitLambdaExp(lexp, false);
            lexp.setCanCall(true);
        } else if (exp.func instanceof QuoteExp && ((QuoteExp)exp.func).getValue() == AppendValues.appendValues) {
            isAppendValues = true;
        } else {
            exp.func = this.visitExpression(exp.func, exp.func);
        }
        if (!(lexp == null || lexp.returnContinuation == returnContinuation || lexp == this.currentLambda && inTailContext)) {
            if (inTailContext) {
                if (lexp.tailCallers == null) {
                    lexp.tailCallers = new HashSet<LambdaExp>();
                }
                lexp.tailCallers.add(this.currentLambda);
            } else if (lexp.returnContinuation == null) {
                lexp.returnContinuation = returnContinuation;
                lexp.inlineHome = this.currentLambda;
            } else {
                lexp.returnContinuation = LambdaExp.unknownContinuation;
                lexp.inlineHome = null;
            }
        }
        exp.args = this.visitExps(exp.args);
        return exp;
    }

    @Override
    protected Expression visitBlockExp(BlockExp exp, Expression returnContinuation) {
        exp.body = exp.body.visit(this, returnContinuation);
        if (exp.exitBody != null) {
            exp.exitBody = exp.exitBody.visit(this, exp.exitBody);
        }
        return exp;
    }

    @Override
    protected Expression visitBeginExp(BeginExp exp, Expression returnContinuation) {
        int n = exp.length - 1;
        for (int i = 0; i <= n; ++i) {
            exp.exps[i] = exp.exps[i].visit(this, i == n ? returnContinuation : exp.exps[i]);
        }
        return exp;
    }

    @Override
    protected Expression visitFluidLetExp(FluidLetExp exp, Expression returnContinuation) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            decl.setCanRead(true);
            if (decl.base == null) continue;
            decl.base.setCanRead(true);
        }
        this.visitLetDecls(exp);
        exp.body = exp.body.visit(this, exp.body);
        this.postVisitDecls(exp);
        return exp;
    }

    void visitLetDecls(LetExp exp) {
        Declaration decl = exp.firstDecl();
        int n = exp.inits.length;
        int i = 0;
        while (i < n) {
            Expression value;
            Expression init = this.visitSetExp(decl, exp.inits[i]);
            if (init == QuoteExp.undefined_exp && ((value = decl.getValue()) instanceof LambdaExp || value != init && value instanceof QuoteExp)) {
                init = value;
            }
            exp.inits[i] = init;
            ++i;
            decl = decl.nextDecl();
        }
    }

    @Override
    protected Expression visitLetExp(LetExp exp, Expression returnContinuation) {
        this.visitLetDecls(exp);
        exp.body = exp.body.visit(this, returnContinuation);
        this.postVisitDecls(exp);
        return exp;
    }

    public void postVisitDecls(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            ReferenceExp rexp;
            Declaration context;
            Expression value = decl.getValue();
            if (value instanceof LambdaExp) {
                LambdaExp lexp = (LambdaExp)value;
                if (decl.getCanRead()) {
                    lexp.setCanRead(true);
                }
                if (decl.getCanCall()) {
                    lexp.setCanCall(true);
                }
            }
            if (!decl.getFlag(1024L) || !(value instanceof ReferenceExp) || (context = (rexp = (ReferenceExp)value).contextDecl()) == null || !context.isPrivate()) continue;
            context.setFlag(524288L);
        }
    }

    @Override
    protected Expression visitIfExp(IfExp exp, Expression returnContinuation) {
        exp.test = exp.test.visit(this, exp.test);
        exp.then_clause = exp.then_clause.visit(this, returnContinuation);
        Expression else_clause = exp.else_clause;
        if (else_clause != null) {
            exp.else_clause = else_clause.visit(this, returnContinuation);
        }
        return exp;
    }

    @Override
    protected Expression visitLambdaExp(LambdaExp exp, Expression returnContinuation) {
        this.visitLambdaExp(exp, true);
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void visitLambdaExp(LambdaExp exp, boolean canRead) {
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        if (canRead) {
            exp.setCanRead(true);
        }
        try {
            if (exp.defaultArgs != null) {
                exp.defaultArgs = this.visitExps(exp.defaultArgs);
            }
            if (this.exitValue == null && exp.body != null) {
                exp.body = exp.body.visit(this, exp.getInlineOnly() ? exp : exp.body);
            }
        }
        finally {
            this.currentLambda = parent;
        }
        this.postVisitDecls(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Expression visitClassExp(ClassExp exp, Expression returnContinuation) {
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        try {
            LambdaExp child = exp.firstChild;
            while (child != null && this.exitValue == null) {
                this.visitLambdaExp(child, false);
                child = child.nextSibling;
            }
        }
        finally {
            this.currentLambda = parent;
        }
        return exp;
    }

    @Override
    protected Expression visitReferenceExp(ReferenceExp exp, Expression returnContinuation) {
        Declaration ctx;
        Declaration decl = Declaration.followAliases(exp.binding);
        if (decl != null) {
            Type type = decl.type;
            if (type != null && type.isVoid()) {
                return QuoteExp.voidExp;
            }
            decl.setCanRead(true);
        }
        if ((ctx = exp.contextDecl()) != null) {
            ctx.setCanRead(true);
        }
        return exp;
    }

    final Expression visitSetExp(Declaration decl, Expression value) {
        if (decl != null && decl.getValue() == value && value instanceof LambdaExp && !(value instanceof ClassExp) && !decl.isPublic()) {
            LambdaExp lexp = (LambdaExp)value;
            this.visitLambdaExp(lexp, false);
            return lexp;
        }
        return value.visit(this, value);
    }

    @Override
    protected Expression visitSetExp(SetExp exp, Expression returnContinuation) {
        Declaration ctx;
        Declaration decl = exp.binding;
        if (decl != null && decl.isAlias()) {
            if (exp.isDefining()) {
                exp.new_value = exp.new_value.visit(this, exp.new_value);
                return exp;
            }
            decl = Declaration.followAliases(decl);
        }
        if ((ctx = exp.contextDecl()) != null) {
            ctx.setCanRead(true);
        }
        Expression value = this.visitSetExp(decl, exp.new_value);
        if (decl != null && decl.context instanceof LetExp && value == decl.getValue() && (value instanceof LambdaExp || value instanceof QuoteExp)) {
            return QuoteExp.voidExp;
        }
        exp.new_value = value;
        return exp;
    }

    @Override
    protected Expression visitTryExp(TryExp exp, Expression returnContinuation) {
        Expression tryContinuation = exp.finally_clause == null ? returnContinuation : exp.try_clause;
        exp.try_clause = exp.try_clause.visit(this, tryContinuation);
        for (CatchClause catch_clause = exp.catch_clauses; this.exitValue == null && catch_clause != null; catch_clause = catch_clause.getNext()) {
            Expression clauseContinuation = exp.finally_clause == null ? returnContinuation : catch_clause.body;
            catch_clause.body = catch_clause.body.visit(this, clauseContinuation);
        }
        Expression finally_clause = exp.finally_clause;
        if (finally_clause != null) {
            exp.finally_clause = finally_clause.visit(this, finally_clause);
        }
        return exp;
    }

    @Override
    protected Expression visitSynchronizedExp(SynchronizedExp exp, Expression returnContinuation) {
        exp.object = exp.object.visit(this, exp.object);
        exp.body = exp.body.visit(this, exp.body);
        return exp;
    }
}

