/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.CompileNamedPart;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.lists.FVector;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import java.util.IdentityHashMap;
import java.util.Vector;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxForms;
import kawa.lang.Translator;

public class Quote
extends Syntax {
    public static final Quote plainQuote = new Quote("quote", false);
    public static final Quote quasiQuote = new Quote("quasiquote", true);
    protected static final int QUOTE_DEPTH = -1;
    protected boolean isQuasi;
    private static final Object WORKING = new String("(working)");
    private static final Object CYCLE = new String("(cycle)");
    static final Method vectorAppendMethod = ClassType.make("kawa.standard.vector_append").getDeclaredMethod("apply$V", 1);
    static final ClassType quoteType = ClassType.make("kawa.lang.Quote");
    static final Method consXMethod = quoteType.getDeclaredMethod("consX$V", 1);
    static final Method appendMethod = quoteType.getDeclaredMethod("append$V", 1);
    static final Method makePairMethod = Compilation.typePair.getDeclaredMethod("make", 2);
    static final Method makeVectorMethod = ClassType.make("gnu.lists.FVector").getDeclaredMethod("make", 1);

    public Quote(String name, boolean isQuasi) {
        super(name);
        this.isQuasi = isQuasi;
    }

    protected Object expand(Object template, int depth, Translator tr) {
        IdentityHashMap seen = new IdentityHashMap();
        return this.expand(template, depth, null, seen, tr);
    }

    public static Object quote(Object obj, Translator tr) {
        return plainQuote.expand(obj, -1, tr);
    }

    public static Object quote(Object obj) {
        return plainQuote.expand(obj, -1, (Translator)Compilation.getCurrent());
    }

    protected Expression coerceExpression(Object val, Translator tr) {
        return val instanceof Expression ? (Expression)val : this.leaf(val, tr);
    }

    protected Expression leaf(Object val, Translator tr) {
        return new QuoteExp(val);
    }

    protected boolean expandColonForms() {
        return true;
    }

    public static Symbol makeSymbol(Namespace ns, Object local) {
        String name = local instanceof CharSequence ? ((Object)((CharSequence)local)).toString() : (String)local;
        return ns.getSymbol(name.intern());
    }

    Object expand_pair(Pair list, int depth, SyntaxForm syntax2, Object seen, Translator tr) {
        Object result;
        Object cdr;
        Object rest;
        block36: {
            Object car;
            Pair pair;
            block38: {
                pair = list;
                while (true) {
                    Pair p2;
                    Pair p1;
                    rest = pair;
                    if (this.expandColonForms() && pair == list && tr.matches(pair.getCar(), syntax2, LispLanguage.lookup_sym) && pair.getCdr() instanceof Pair && (p1 = (Pair)pair.getCdr()) instanceof Pair && (p2 = (Pair)p1.getCdr()) instanceof Pair && p2.getCdr() == LList.Empty) {
                        Expression part1 = tr.rewrite_car(p1, false);
                        Expression part2 = tr.rewrite_car(p2, false);
                        Namespace ns = tr.namespaceResolvePrefix(part1);
                        Symbol sym = tr.namespaceResolve(ns, part2);
                        if (sym != null) {
                            cdr = sym;
                        } else if (ns != null && depth == 1) {
                            cdr = new ApplyExp(quoteType.getDeclaredMethod("makeSymbol", 2), new Expression[]{QuoteExp.getInstance(ns), part2});
                        } else if (part1 instanceof ReferenceExp && part2 instanceof QuoteExp) {
                            cdr = tr.getGlobalEnvironment().getSymbol(((ReferenceExp)part1).getName() + ':' + ((QuoteExp)part2).getValue().toString());
                        } else {
                            String combinedName = CompileNamedPart.combineName(part1, part2);
                            if (combinedName != null) {
                                cdr = tr.getGlobalEnvironment().getSymbol(combinedName);
                            } else {
                                Object save = tr.pushPositionOf(pair);
                                tr.error('e', "'" + p1.getCar() + "' is not a valid prefix");
                                tr.popPositionOf(save);
                                cdr = sym;
                            }
                        }
                        break block36;
                    }
                    if (depth >= 0) {
                        if (tr.matches(pair.getCar(), syntax2, "quasiquote")) {
                            ++depth;
                        } else if (tr.matches(pair.getCar(), syntax2, "unquote")) {
                            Pair pair_cdr;
                            --depth;
                            if (!(pair.getCdr() instanceof Pair) || (pair_cdr = (Pair)pair.getCdr()).getCdr() != LList.Empty) {
                                return tr.syntaxError("invalid used of " + pair.getCar() + " in quasiquote template");
                            }
                            if (depth == 0) {
                                cdr = tr.rewrite_car(pair_cdr, syntax2);
                                break block36;
                            }
                        } else if (tr.matches(pair.getCar(), syntax2, "unquote-splicing")) {
                            return tr.syntaxError("invalid used of " + pair.getCar() + " in quasiquote template");
                        }
                    }
                    if (depth == 1 && pair.getCar() instanceof Pair) {
                        Object form = pair.getCar();
                        SyntaxForm subsyntax = syntax2;
                        while (form instanceof SyntaxForm) {
                            subsyntax = (SyntaxForm)form;
                            form = subsyntax.getDatum();
                        }
                        int splicing = -1;
                        if (form instanceof Pair) {
                            Object op = ((Pair)form).getCar();
                            if (tr.matches(op, subsyntax, "unquote")) {
                                splicing = 0;
                            } else if (tr.matches(op, subsyntax, "unquote-splicing")) {
                                splicing = 1;
                            }
                        }
                        if (splicing >= 0) {
                            Vector<Expression> vec;
                            block37: {
                                form = ((Pair)form).getCdr();
                                vec = new Vector<Expression>();
                                cdr = null;
                                while (true) {
                                    if (form instanceof SyntaxForm) {
                                        subsyntax = (SyntaxForm)form;
                                        form = subsyntax.getDatum();
                                    }
                                    if (form == LList.Empty) break block37;
                                    if (!(form instanceof Pair)) break;
                                    vec.addElement(tr.rewrite_car((Pair)form, subsyntax));
                                    form = ((Pair)form).getCdr();
                                }
                                return tr.syntaxError("improper list argument to unquote");
                            }
                            int nargs = vec.size() + 1;
                            cdr = this.expand(pair.getCdr(), 1, syntax2, seen, tr);
                            if (nargs > 1) {
                                Object[] args = new Expression[nargs];
                                vec.copyInto(args);
                                args[nargs - 1] = this.coerceExpression(cdr, tr);
                                Method method = splicing == 0 ? consXMethod : appendMethod;
                                cdr = new ApplyExp(method, (Expression[])args);
                            }
                            rest = pair;
                            break block36;
                        }
                    }
                    if ((car = this.expand(pair.getCar(), depth, syntax2, seen, tr)) != pair.getCar()) break block38;
                    rest = pair.getCdr();
                    if (!(rest instanceof Pair)) break;
                    pair = (Pair)rest;
                }
                cdr = this.expand(rest, depth, syntax2, seen, tr);
                break block36;
            }
            cdr = this.expand(pair.getCdr(), depth, syntax2, seen, tr);
            if (car instanceof Expression || cdr instanceof Expression) {
                Expression[] args = new Expression[]{this.coerceExpression(car, tr), this.coerceExpression(cdr, tr)};
                cdr = new ApplyExp(makePairMethod, args);
            } else {
                cdr = Translator.makePair(pair, car, cdr);
            }
        }
        if (list == rest) {
            return cdr;
        }
        Pair p = list;
        Pair[] pairs = new Pair[20];
        int npairs = 0;
        while (true) {
            if (npairs >= pairs.length) {
                Pair[] tmp = new Pair[2 * npairs];
                System.arraycopy(pairs, 0, tmp, 0, npairs);
                pairs = tmp;
            }
            pairs[npairs++] = p;
            if (p.getCdr() == rest) break;
            p = (Pair)p.getCdr();
        }
        Object object2 = result = cdr instanceof Expression ? LList.Empty : cdr;
        while (--npairs >= 0) {
            p = pairs[npairs];
            result = Translator.makePair(p, p.getCar(), result);
        }
        if (cdr instanceof Expression) {
            Expression[] args = new Expression[2];
            args[1] = (Expression)cdr;
            if (npairs == 1) {
                args[0] = this.leaf(list.getCar(), tr);
                return new ApplyExp(makePairMethod, args);
            }
            args[0] = this.leaf(result, tr);
            return new ApplyExp(appendMethod, args);
        }
        return result;
    }

    Object expand(Object template, int depth, SyntaxForm syntax2, Object seen, Translator tr) {
        Object result;
        IdentityHashMap map = (IdentityHashMap)seen;
        Object old = map.get(template);
        if (old == WORKING) {
            map.put(template, CYCLE);
            return old;
        }
        if (old == CYCLE) {
            return old;
        }
        if (old != null) {
            return old;
        }
        if (template instanceof Pair) {
            result = this.expand_pair((Pair)template, depth, syntax2, seen, tr);
        } else if (template instanceof SyntaxForm) {
            syntax2 = (SyntaxForm)template;
            result = this.expand(syntax2.getDatum(), depth, syntax2, seen, tr);
        } else if (template instanceof FVector) {
            FVector vector = (FVector)template;
            int n = vector.size();
            Object[] buffer = new Object[n];
            byte[] state = new byte[n];
            byte max_state = 0;
            for (int i = 0; i < n; ++i) {
                Pair pair;
                Object element = vector.get(i);
                int element_depth = depth;
                if (element instanceof Pair && depth > -1 && tr.matches((pair = (Pair)element).getCar(), syntax2, "unquote-splicing") && --element_depth == 0) {
                    Pair pair_cdr;
                    if (!(pair.getCdr() instanceof Pair) || (pair_cdr = (Pair)pair.getCdr()).getCdr() != LList.Empty) {
                        return tr.syntaxError("invalid used of " + pair.getCar() + " in quasiquote template");
                    }
                    buffer[i] = tr.rewrite_car(pair_cdr, syntax2);
                    state[i] = 3;
                } else {
                    buffer[i] = this.expand(element, element_depth, syntax2, seen, tr);
                    state[i] = buffer[i] == element ? 0 : (buffer[i] instanceof Expression ? 2 : 1);
                }
                if (state[i] <= max_state) continue;
                max_state = state[i];
            }
            if (max_state == 0) {
                result = vector;
            } else if (max_state == 1) {
                result = new FVector(buffer);
            } else {
                Expression[] args = new Expression[n];
                for (int i = 0; i < n; ++i) {
                    Object[] arg1;
                    if (state[i] == 3) {
                        args[i] = (Expression)buffer[i];
                        continue;
                    }
                    if (max_state < 3) {
                        args[i] = this.coerceExpression(buffer[i], tr);
                        continue;
                    }
                    if (state[i] < 2) {
                        arg1 = new Object[]{buffer[i]};
                        args[i] = this.leaf(new FVector(arg1), tr);
                        continue;
                    }
                    arg1 = new Expression[]{(Expression)buffer[i]};
                    args[i] = Quote.makeInvokeMakeVector((Expression[])arg1);
                }
                result = max_state < 3 ? Quote.makeInvokeMakeVector(args) : new ApplyExp(vectorAppendMethod, args);
            }
        } else {
            result = template;
        }
        if (template != result && map.get(template) == CYCLE) {
            tr.error('e', "cycle in non-literal data");
        }
        map.put(template, result);
        return result;
    }

    private static ApplyExp makeInvokeMakeVector(Expression[] args) {
        return new ApplyExp(makeVectorMethod, args);
    }

    @Override
    public Expression rewrite(Object obj, Translator tr) {
        Pair pair;
        if (!(obj instanceof Pair) || (pair = (Pair)obj).getCdr() != LList.Empty) {
            return tr.syntaxError("wrong number of arguments to quote");
        }
        return this.coerceExpression(this.expand(pair.getCar(), this.isQuasi ? 1 : -1, tr), tr);
    }

    public static Object consX$V(Object[] args) {
        return LList.consX(args);
    }

    public static Object append$V(Object[] args) {
        int count = args.length;
        if (count == 0) {
            return LList.Empty;
        }
        Object result = args[count - 1];
        int i = count - 1;
        while (--i >= 0) {
            Object list = args[i];
            Pair copy = null;
            Pair last = null;
            SyntaxForm syntax2 = null;
            while (true) {
                if (list instanceof SyntaxForm) {
                    syntax2 = (SyntaxForm)list;
                    list = syntax2.getDatum();
                    continue;
                }
                if (list == LList.Empty) break;
                Pair list_pair = (Pair)list;
                Object car = list_pair.getCar();
                if (syntax2 != null && !(car instanceof SyntaxForm)) {
                    car = SyntaxForms.makeForm(car, syntax2.getScope());
                }
                Pair new_pair = new Pair(car, null);
                if (last == null) {
                    copy = new_pair;
                } else {
                    last.setCdr(new_pair);
                }
                last = new_pair;
                list = list_pair.getCdr();
            }
            if (last == null) continue;
            last.setCdr(result);
            result = copy;
        }
        return result;
    }
}

