/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Member;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.ThisExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.functions.GetNamedPart;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.FieldLocation;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.xml.MakeAttribute;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Macro;
import kawa.lang.PatternScope;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.TemplateScope;
import kawa.standard.Scheme;
import kawa.standard.begin;
import kawa.standard.require;

public class Translator
extends Compilation {
    private Environment env;
    public Macro currentMacroDefinition;
    public PatternScope patternScope;
    public Declaration templateScopeDecl;
    public Declaration matchArray;
    Stack renamedAliasStack;
    public Stack formStack = new Stack();
    public int firstForm;
    public Object pendingForm;
    public LambdaExp curMethodLambda;
    private static Expression errorExp = new ErrorExp("unknown syntax error");
    Syntax currentSyntax;
    Declaration macroContext;
    PairWithPosition positionPair;
    Vector notedAccess;

    public boolean isLexical(Declaration decl) {
        if (decl == null) {
            return false;
        }
        if (!decl.isFluid()) {
            return true;
        }
        ScopeExp scope = this.currentScope();
        ScopeExp context = decl.getContext();
        while (scope != null) {
            if (scope == context) {
                return true;
            }
            if (scope instanceof LambdaExp && !((LambdaExp)scope).getInlineOnly()) {
                return false;
            }
            scope = scope.outer;
        }
        return false;
    }

    public Translator(Language language, SourceMessages messages) {
        super(language, messages);
        this.env = Environment.getCurrent();
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object input) {
        return this.rewrite(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression rewrite_car(Pair pair, SyntaxForm syntax2) {
        if (syntax2 == null || syntax2.scope == this.current_scope || pair.car instanceof SyntaxForm) {
            return this.rewrite_car(pair, false);
        }
        ScopeExp save_scope = this.current_scope;
        try {
            this.setCurrentScope(syntax2.scope);
            Expression expression = this.rewrite_car(pair, false);
            return expression;
        }
        finally {
            this.setCurrentScope(save_scope);
        }
    }

    public final Expression rewrite_car(Pair pair, boolean function2) {
        Object car = pair.car;
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(car, function2, (PairWithPosition)pair);
        }
        return this.rewrite(car, function2);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression apply_rewrite(Syntax syntax2, Pair form) {
        Expression exp = errorExp;
        Syntax saveSyntax = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            exp = syntax2.rewriteForm(form, this);
        }
        finally {
            this.currentSyntax = saveSyntax;
        }
        return exp;
    }

    static ReferenceExp getOriginalRef(Declaration decl) {
        Expression value;
        if (decl != null && decl.isAlias() && !decl.isIndirectBinding() && (value = decl.getValue()) instanceof ReferenceExp) {
            return (ReferenceExp)value;
        }
        return null;
    }

    final boolean selfEvaluatingSymbol(Object obj) {
        return ((LispLanguage)this.getLanguage()).selfEvaluatingSymbol(obj);
    }

    public final boolean matches(Object form, String literal) {
        return this.matches(form, null, literal);
    }

    public boolean matches(Object form, SyntaxForm syntax2, String literal) {
        ReferenceExp rexp;
        if (syntax2 != null) {
            // empty if block
        }
        if (form instanceof SyntaxForm) {
            return literal == ((SyntaxForm)form).form;
        }
        if (form instanceof Symbol && !this.selfEvaluatingSymbol(form) && (rexp = Translator.getOriginalRef(this.lexical.lookup(form, -1))) != null) {
            form = rexp.getSymbol();
        }
        return form == literal;
    }

    public Declaration lookup(Object name, int namespace) {
        Declaration decl = this.lexical.lookup(name, namespace);
        if (decl != null && this.getLanguage().hasNamespace(decl, namespace)) {
            return decl;
        }
        return this.currentModule().lookup(name, this.getLanguage(), namespace);
    }

    public Declaration lookupGlobal(Object name) {
        return this.lookupGlobal(name, -1);
    }

    public Declaration lookupGlobal(Object name, int namespace) {
        ModuleExp module = this.currentModule();
        Declaration decl = module.lookup(name, this.getLanguage(), namespace);
        if (decl == null) {
            decl = module.getNoDefine(name);
            decl.setIndirectBinding(true);
        }
        return decl;
    }

    Syntax check_if_Syntax(Declaration decl) {
        Declaration d = Declaration.followAliases(decl);
        Expression dval = d.getValue();
        if (dval != null && d.getFlag(32768)) {
            try {
                if (decl.getValue() instanceof ReferenceExp) {
                    Declaration context = ((ReferenceExp)decl.getValue()).contextDecl();
                    if (context != null) {
                        this.macroContext = context;
                    } else if (this.current_scope instanceof TemplateScope) {
                        this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                    }
                } else if (this.current_scope instanceof TemplateScope) {
                    this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                }
                Object obj = dval.eval(this.env);
                return obj instanceof Syntax ? (Syntax)obj : null;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.error('e', "unable to evaluate macro for " + decl.getSymbol());
            }
        }
        return null;
    }

    public Expression rewrite_pair(Pair p, boolean function2) {
        int cdr_length;
        if (p.car instanceof Syntax) {
            return this.apply_rewrite((Syntax)p.car, p);
        }
        Object cdr = p.cdr;
        Expression func = this.rewrite_car(p, true);
        Object proc = null;
        ReferenceExp ref = null;
        if (func instanceof ReferenceExp) {
            ref = (ReferenceExp)func;
            Declaration decl = ref.getBinding();
            if (decl == null) {
                String name;
                Symbol symbol;
                Object sym = ref.getSymbol();
                if (sym instanceof Symbol && !this.selfEvaluatingSymbol(sym)) {
                    symbol = (Symbol)sym;
                    name = symbol.getName();
                } else {
                    name = sym.toString();
                    symbol = this.env.getSymbol(name);
                }
                proc = this.env.get(symbol, this.getLanguage().hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null, null);
                if (proc instanceof Syntax) {
                    return this.apply_rewrite((Syntax)proc, p);
                }
                if (proc instanceof AutoloadProcedure) {
                    try {
                        proc = ((AutoloadProcedure)proc).getLoaded();
                    }
                    catch (RuntimeException ex) {
                        proc = null;
                    }
                }
            } else {
                Declaration saveContext = this.macroContext;
                Syntax syntax2 = this.check_if_Syntax(decl);
                if (syntax2 != null) {
                    Expression e = this.apply_rewrite(syntax2, p);
                    this.macroContext = saveContext;
                    return e;
                }
            }
            ref.setProcedureName(true);
            if (this.getLanguage().hasSeparateFunctionNamespace()) {
                func.setFlag(4);
            }
        }
        if ((cdr_length = Translator.listLength(cdr)) == -1) {
            return this.syntaxError("circular list is not allowed after " + p.car);
        }
        if (cdr_length < 0) {
            return this.syntaxError("dotted list [" + cdr + "] is not allowed after " + p.car);
        }
        boolean mapKeywordsToAttributes = false;
        Stack<Expression> vec = new Stack<Expression>();
        ScopeExp save_scope = this.current_scope;
        int i = 0;
        while (i < cdr_length) {
            if (cdr instanceof SyntaxForm) {
                SyntaxForm sf = (SyntaxForm)cdr;
                cdr = sf.form;
                this.setCurrentScope(sf.scope);
            }
            Pair cdr_pair = (Pair)cdr;
            Expression arg = this.rewrite_car(cdr_pair, false);
            ++i;
            if (mapKeywordsToAttributes) {
                Object value;
                if ((i & 1) == 0) {
                    Expression[] aargs = new Expression[]{(Expression)vec.pop(), arg};
                    arg = new ApplyExp(MakeAttribute.makeAttribute, aargs);
                } else if (arg instanceof QuoteExp && (value = ((QuoteExp)arg).getValue()) instanceof Keyword && i < cdr_length) {
                    arg = new QuoteExp(((Keyword)value).asSymbol());
                } else {
                    mapKeywordsToAttributes = false;
                }
            }
            vec.addElement(arg);
            cdr = cdr_pair.cdr;
        }
        Object[] args = new Expression[vec.size()];
        vec.copyInto(args);
        if (save_scope != this.current_scope) {
            this.setCurrentScope(save_scope);
        }
        return ((LispLanguage)this.getLanguage()).makeApply(func, (Expression[])args);
    }

    public Symbol namespaceResolve(Expression context, Expression member) {
        if (context instanceof ReferenceExp && member instanceof QuoteExp) {
            Object val;
            ReferenceExp rexp = (ReferenceExp)context;
            Declaration decl = rexp.getBinding();
            if (decl == null || decl.getFlag(65536)) {
                Object rsym = rexp.getSymbol();
                Symbol sym = rsym instanceof Symbol ? (Symbol)rsym : this.env.getSymbol(rsym.toString());
                val = this.env.get(sym, null);
            } else {
                val = decl.isNamespaceDecl() ? decl.getConstantValue() : null;
            }
            if (val instanceof Namespace) {
                Namespace ns = (Namespace)val;
                String uri = ns.getName();
                if (uri != null && uri.startsWith("class:")) {
                    return null;
                }
                String mem = ((QuoteExp)member).getValue().toString().intern();
                return ns.getSymbol(mem);
            }
        }
        return null;
    }

    public static Object stripSyntax(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).form;
        }
        return obj;
    }

    public static Object safeCar(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).form;
        }
        if (!(obj instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)obj).car);
    }

    public static Object safeCdr(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).form;
        }
        if (!(obj instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)obj).cdr);
    }

    public static int listLength(Object obj) {
        int n = 0;
        Object slow = obj;
        Object fast = obj;
        while (true) {
            if (fast instanceof SyntaxForm) {
                fast = ((SyntaxForm)fast).form;
                continue;
            }
            while (slow instanceof SyntaxForm) {
                slow = ((SyntaxForm)slow).form;
            }
            if (fast == LList.Empty) {
                return n;
            }
            if (!(fast instanceof Pair)) {
                return -1 - n;
            }
            ++n;
            Object next = ((Pair)fast).cdr;
            while (next instanceof SyntaxForm) {
                next = ((SyntaxForm)next).form;
            }
            if (next == LList.Empty) {
                return n;
            }
            if (!(next instanceof Pair)) {
                return -1 - n;
            }
            slow = ((Pair)slow).cdr;
            fast = ((Pair)next).cdr;
            ++n;
            if (fast == slow) break;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteInBody(Object exp) {
        if (exp instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)exp;
            ScopeExp save_scope = this.current_scope;
            try {
                this.setCurrentScope(sf.scope);
                this.rewriteInBody(sf.form);
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        } else if (exp instanceof Values) {
            Object[] vals = ((Values)exp).getValues();
            for (int i = 0; i < vals.length; ++i) {
                this.rewriteInBody(vals[i]);
            }
        } else {
            this.formStack.add(this.rewrite(exp, false));
        }
    }

    public Expression rewrite(Object exp) {
        return this.rewrite(exp, false);
    }

    public Object namespaceResolve(Object name) {
        Pair p;
        if (!(name instanceof String) && name instanceof Pair && Translator.safeCar(p = (Pair)name) == "$lookup$" && p.cdr instanceof Pair) {
            p = (Pair)p.cdr;
            if (p.cdr instanceof Pair) {
                Expression part2;
                Expression part1 = this.rewrite(p.car);
                Symbol sym = this.namespaceResolve(part1, part2 = this.rewrite(((Pair)p.cdr).car));
                if (sym != null) {
                    return sym;
                }
                String combinedName = GetNamedPart.combineName(part1, part2);
                if (combinedName != null) {
                    return combinedName;
                }
            }
        }
        return name;
    }

    public void setCurrentScope(ScopeExp scope) {
        super.setCurrentScope(scope);
        while (scope != null && !(scope instanceof PatternScope)) {
            scope = scope.outer;
        }
        this.patternScope = (PatternScope)scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite(Object exp, boolean function2) {
        if (exp instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)exp;
            ScopeExp save_scope = this.current_scope;
            try {
                Expression s;
                this.setCurrentScope(sf.scope);
                Expression expression = s = this.rewrite(sf.form, function2);
                return expression;
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        }
        if (exp instanceof PairWithPosition) {
            return this.rewrite_with_position(exp, function2, (PairWithPosition)exp);
        }
        if (exp instanceof Pair) {
            return this.rewrite_pair((Pair)exp, function2);
        }
        if (exp instanceof String || exp instanceof Symbol && !this.selfEvaluatingSymbol(exp)) {
            Object nameToLookup;
            String dname;
            int decl_nesting;
            Declaration decl = this.lexical.lookup(exp, function2);
            Declaration cdecl = null;
            ScopeExp scope = this.current_scope;
            int n = decl_nesting = decl == null ? -1 : ScopeExp.nesting(decl.context);
            if (exp instanceof String || exp instanceof Symbol && ((Symbol)exp).hasEmptyNamespace()) {
                dname = exp.toString();
            } else {
                dname = null;
                scope = null;
            }
            while (scope != null) {
                if (scope instanceof LambdaExp && scope.outer instanceof ClassExp && ((LambdaExp)scope).isClassMethod()) {
                    char mode;
                    PrimProcedure[] methods;
                    boolean contextStatic;
                    if (decl_nesting >= ScopeExp.nesting(scope.outer)) break;
                    LambdaExp caller = (LambdaExp)scope;
                    ClassExp cexp = (ClassExp)scope.outer;
                    ClassType ctype = (ClassType)cexp.getType();
                    Member part = SlotGet.lookupMember(ctype, dname, ctype);
                    boolean bl = contextStatic = caller == cexp.clinitMethod || caller != cexp.initMethod && caller.nameDecl.isStatic();
                    if (part != null || (methods = ClassMethods.getMethods(ctype, dname, mode = contextStatic ? (char)'S' : 'V', ctype, this.language)).length != 0) {
                        ReferenceExp part1 = contextStatic ? new ReferenceExp(((ClassExp)caller.outer).nameDecl) : new ThisExp(caller.firstDecl());
                        return GetNamedPart.makeExp((Expression)part1, QuoteExp.getInstance(dname));
                    }
                }
                scope = scope.outer;
            }
            Symbol symbol = null;
            if (decl != null) {
                nameToLookup = decl.getSymbol();
                exp = null;
                ReferenceExp rexp = Translator.getOriginalRef(decl);
                if (rexp != null && (decl = rexp.getBinding()) == null) {
                    nameToLookup = exp = rexp.getSymbol();
                }
            } else {
                nameToLookup = exp;
            }
            symbol = exp instanceof String ? this.env.getSymbol((String)exp) : (Symbol)exp;
            boolean separate = this.getLanguage().hasSeparateFunctionNamespace();
            if (decl != null) {
                if (!this.isLexical(decl) || separate && decl.isProcedureDecl()) {
                    decl = null;
                } else if (this.current_scope instanceof TemplateScope && decl.needsContext()) {
                    cdecl = ((TemplateScope)this.current_scope).macroContext;
                } else if (decl.getFlag(0x100000) && !decl.isStatic()) {
                    scope = this.currentScope();
                    while (true) {
                        if (scope == null) {
                            throw new Error("internal error: missing " + decl);
                        }
                        if (scope.outer == decl.context) break;
                        scope = scope.outer;
                    }
                    cdecl = scope.firstDecl();
                }
            } else {
                Location loc = this.env.lookup(symbol, function2 && separate ? EnvironmentKey.FUNCTION : null);
                if (loc != null) {
                    loc = loc.getBase();
                }
                if (loc instanceof FieldLocation) {
                    FieldLocation floc = (FieldLocation)loc;
                    try {
                        decl = floc.getDeclaration();
                        if (!this.inlineOk(null) && decl != Scheme.getNamedPartDecl) {
                            decl = null;
                        }
                        if (decl != null && !decl.isStatic()) {
                            cdecl = new Declaration("(module-instance)");
                            cdecl.setValue(new QuoteExp(floc.getInstance()));
                        }
                    }
                    catch (Throwable ex) {
                        this.error('e', "exception loading '" + exp + "' - " + ex.getMessage());
                        decl = null;
                    }
                }
            }
            if (decl != null && decl.getContext() instanceof PatternScope) {
                return this.syntaxError("reference to pattern variable " + decl.getName() + " outside syntax template");
            }
            ReferenceExp rexp = new ReferenceExp(nameToLookup, decl);
            rexp.setContextDecl(cdecl);
            rexp.setLine(this);
            if (function2 && separate) {
                rexp.setFlag(4);
            }
            return rexp;
        }
        if (exp instanceof LangExp) {
            return this.rewrite(((LangExp)exp).getLangValue(), function2);
        }
        if (exp instanceof Expression) {
            return (Expression)exp;
        }
        return QuoteExp.getInstance(Quote.quote(exp, this));
    }

    public static void setLine(Expression exp, Object location2) {
        if (location2 instanceof SourceLocator) {
            exp.setLocation((SourceLocator)location2);
        }
    }

    public static void setLine(Declaration decl, Object location2) {
        if (location2 instanceof SourceLocator) {
            decl.setLocation((SourceLocator)location2);
        }
    }

    public Object pushPositionOf(Object pair) {
        if (pair instanceof SyntaxForm) {
            pair = ((SyntaxForm)pair).form;
        }
        if (!(pair instanceof PairWithPosition)) {
            return null;
        }
        PairWithPosition ppair = (PairWithPosition)pair;
        PairWithPosition saved = this.positionPair == null || this.positionPair.getFileName() != this.getFileName() || this.positionPair.getLineNumber() != this.getLineNumber() || this.positionPair.getColumnNumber() != this.getColumnNumber() ? new PairWithPosition(this, Special.eof, this.positionPair) : this.positionPair;
        this.setLine(pair);
        this.positionPair = ppair;
        return saved;
    }

    public void popPositionOf(Object saved) {
        if (saved == null) {
            return;
        }
        this.setLine(saved);
        this.positionPair = (PairWithPosition)saved;
        if (this.positionPair.car == Special.eof) {
            this.positionPair = (PairWithPosition)this.positionPair.cdr;
        }
    }

    public void setLine(Object location2) {
        if (location2 instanceof SourceLocator) {
            this.setLocation((SourceLocator)location2);
        }
    }

    public void setLineOf(Expression exp) {
        if (exp instanceof QuoteExp) {
            return;
        }
        exp.setLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type exp2Type(Pair typeSpecPair) {
        Object saved = this.pushPositionOf(typeSpecPair);
        try {
            Expression texp = this.rewrite_car(typeSpecPair, false);
            texp = new InlineCalls(this).walk(texp);
            if (texp instanceof ErrorExp) {
                Type type = null;
                return type;
            }
            texp = new InlineCalls(this).walk(texp);
            Type type = this.getLanguage().getTypeFor(texp);
            if (type == null) {
                if (texp instanceof ReferenceExp) {
                    this.error('e', "unknown type name '" + ((ReferenceExp)texp).getName() + '\'');
                } else {
                    this.error('e', "invalid type spec (must be \"type\" or 'type or <type>)");
                }
                ClassType classType = Type.pointer_type;
                return classType;
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.popPositionOf(saved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_with_position(Object exp, boolean function2, PairWithPosition pair) {
        Expression result;
        Object saved = this.pushPositionOf(pair);
        try {
            result = exp == pair ? this.rewrite_pair(pair, function2) : this.rewrite(exp, function2);
            this.setLineOf(result);
        }
        finally {
            this.popPositionOf(saved);
        }
        return result;
    }

    public static Object wrapSyntax(Object form, SyntaxForm syntax2) {
        if (syntax2 == null || form instanceof Expression) {
            return form;
        }
        return syntax2.fromDatumIfNeeded(form);
    }

    public Object popForms(int first) {
        Object r;
        int last = this.formStack.size();
        if (last == first) {
            return Values.empty;
        }
        if (last == first + 1) {
            r = this.formStack.elementAt(first);
        } else {
            Values vals = new Values();
            for (int i = first; i < last; ++i) {
                vals.writeObject(this.formStack.elementAt(i));
            }
            r = vals;
        }
        this.formStack.setSize(first);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForm(Object st, ScopeExp defs) {
        if (st instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)st;
            ScopeExp save_scope = this.currentScope();
            try {
                this.setCurrentScope(sf.scope);
                int first = this.formStack.size();
                this.scanForm(sf.form, defs);
                this.formStack.add(Translator.wrapSyntax(this.popForms(first), sf));
                return;
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        }
        if (st instanceof Values) {
            if (st == Values.empty) {
                st = QuoteExp.voidExp;
            } else {
                Object[] vals = ((Values)st).getValues();
                for (int i = 0; i < vals.length; ++i) {
                    this.scanForm(vals[i], defs);
                }
                return;
            }
        }
        if (st instanceof Pair) {
            Pair st_pair = (Pair)st;
            Declaration saveContext = this.macroContext;
            Syntax syntax2 = null;
            ScopeExp save_scope = this.current_scope;
            try {
                Object obj = st_pair.car;
                if (obj instanceof SyntaxForm) {
                    SyntaxForm sf = (SyntaxForm)st_pair.car;
                    this.setCurrentScope(sf.scope);
                    obj = sf.form;
                }
                if (obj instanceof Pair) {
                    Pair p = (Pair)obj;
                    if (p.car == "$lookup$" && p.cdr instanceof Pair) {
                        p = (Pair)p.cdr;
                        if (p.cdr instanceof Pair) {
                            Expression part1 = this.rewrite(p.car);
                            Expression part2 = this.rewrite(((Pair)p.cdr).car);
                            obj = this.namespaceResolve(part1, part2);
                        }
                    }
                }
                if (obj instanceof String || obj instanceof Symbol && !this.selfEvaluatingSymbol(obj)) {
                    Expression func = this.rewrite(obj, true);
                    if (func instanceof ReferenceExp) {
                        Declaration decl = ((ReferenceExp)func).getBinding();
                        if (decl != null) {
                            syntax2 = this.check_if_Syntax(decl);
                        } else if ((obj = this.resolve(obj, true)) instanceof Syntax) {
                            syntax2 = (Syntax)obj;
                        }
                    }
                } else if (obj == begin.begin) {
                    syntax2 = (Syntax)obj;
                }
            }
            finally {
                if (save_scope != this.current_scope) {
                    this.setCurrentScope(save_scope);
                }
            }
            if (syntax2 != null) {
                String save_filename = this.getFileName();
                int save_line = this.getLineNumber();
                int save_column = this.getColumnNumber();
                try {
                    this.setLine(st_pair);
                    syntax2.scanForm(st_pair, defs, this);
                    return;
                }
                finally {
                    this.macroContext = saveContext;
                    this.setLine(save_filename, save_line, save_column);
                }
            }
        }
        this.formStack.add(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object scanBody(Object body, ScopeExp defs, boolean makeList) {
        LList list = makeList ? LList.Empty : null;
        Pair lastPair = null;
        while (body != LList.Empty) {
            if (body instanceof SyntaxForm) {
                SyntaxForm sf = (SyntaxForm)body;
                ScopeExp save_scope = this.current_scope;
                try {
                    Object object2;
                    this.setCurrentScope(sf.scope);
                    int first = this.formStack.size();
                    Object f = this.scanBody(sf.form, defs, makeList);
                    if (makeList) {
                        f = Translator.wrapSyntax(f, sf);
                        if (lastPair == null) {
                            object2 = f;
                            return object2;
                        }
                        lastPair.cdr = f;
                        object2 = list;
                        return object2;
                    }
                    this.formStack.add(Translator.wrapSyntax(this.popForms(first), sf));
                    object2 = null;
                    return object2;
                }
                finally {
                    this.setCurrentScope(save_scope);
                }
            }
            if (body instanceof Pair) {
                Pair pair = (Pair)body;
                int first = this.formStack.size();
                this.scanForm(pair.car, defs);
                if (this.getState() == 2) {
                    if (pair.car != this.pendingForm) {
                        pair = Translator.makePair(pair, this.pendingForm, pair.cdr);
                    }
                    this.pendingForm = new Pair(begin.begin, pair);
                    return LList.Empty;
                }
                int fsize = this.formStack.size();
                if (makeList) {
                    for (int i = first; i < fsize; ++i) {
                        Pair npair = Translator.makePair(pair, this.formStack.elementAt(i), LList.Empty);
                        if (lastPair == null) {
                            list = npair;
                        } else {
                            lastPair.cdr = npair;
                        }
                        lastPair = npair;
                    }
                    this.formStack.setSize(first);
                }
                body = pair.cdr;
                continue;
            }
            this.formStack.add(this.syntaxError("body is not a proper list"));
            break;
        }
        return list;
    }

    public static Pair makePair(Pair pair, Object car, Object cdr) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, car, cdr);
        }
        return new Pair(car, cdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_body(Object exp) {
        Object saved = this.pushPositionOf(exp);
        LetExp defs = new LetExp(null);
        int first = this.formStack.size();
        defs.outer = this.current_scope;
        this.current_scope = defs;
        try {
            int ndecls;
            this.scanBody(exp, defs, false);
            if (this.formStack.size() == first) {
                this.formStack.add(this.syntaxError("body with no expressions"));
            }
            if ((ndecls = defs.countDecls()) != 0) {
                Expression[] inits = new Expression[ndecls];
                int i = ndecls;
                while (--i >= 0) {
                    inits[i] = QuoteExp.undefined_exp;
                }
                defs.inits = inits;
            }
            Expression body = this.makeBody(first, null);
            this.setLineOf(body);
            if (ndecls == 0) {
                Expression expression = body;
                return expression;
            }
            defs.body = body;
            this.setLineOf(defs);
            LetExp letExp = defs;
            return letExp;
        }
        finally {
            this.pop(defs);
            this.popPositionOf(saved);
        }
    }

    public void rewriteBody(int first) {
        int nforms = this.formStack.size() - first;
        if (nforms == 0) {
            return;
        }
        if (nforms == 1) {
            Object f = this.formStack.pop();
            this.rewriteInBody(f);
        } else {
            int i;
            Object[] forms = new Object[nforms];
            for (i = 0; i < nforms; ++i) {
                forms[i] = this.formStack.elementAt(first + i);
            }
            this.formStack.setSize(first);
            for (i = 0; i < nforms; ++i) {
                this.rewriteInBody(forms[i]);
            }
        }
    }

    public Expression makeBody(int first, ScopeExp scope) {
        this.rewriteBody(first);
        int nforms = this.formStack.size() - first;
        if (nforms == 0) {
            return QuoteExp.voidExp;
        }
        if (nforms == 1) {
            return (Expression)this.formStack.pop();
        }
        Expression[] exps = new Expression[nforms];
        for (int i = 0; i < nforms; ++i) {
            exps[i] = (Expression)this.formStack.elementAt(first + i);
        }
        this.formStack.setSize(first);
        if (scope instanceof ModuleExp) {
            return new ApplyExp(AppendValues.appendValues, exps);
        }
        return ((LispLanguage)this.getLanguage()).makeBody(exps);
    }

    public void noteAccess(Object name, ScopeExp scope) {
        if (this.notedAccess == null) {
            this.notedAccess = new Vector();
        }
        this.notedAccess.addElement(name);
        this.notedAccess.addElement(scope);
    }

    public void processAccesses() {
        if (this.notedAccess == null) {
            return;
        }
        int sz = this.notedAccess.size();
        ScopeExp saveScope = this.current_scope;
        for (int i = 0; i < sz; i += 2) {
            Declaration decl;
            Object name = this.notedAccess.elementAt(i);
            ScopeExp scope = (ScopeExp)this.notedAccess.elementAt(i + 1);
            if (this.current_scope != scope) {
                this.setCurrentScope(scope);
            }
            if ((decl = this.lexical.lookup(name, -1)) == null || decl.getFlag(65536)) continue;
            decl.getContext().currentLambda().capture(decl);
            decl.setCanRead(true);
            decl.setSimple(false);
            decl.setFlag(524288);
        }
        if (this.current_scope != saveScope) {
            this.setCurrentScope(saveScope);
        }
    }

    public void finishModule(ModuleExp mexp) {
        boolean moduleStatic = mexp.isStatic();
        for (Declaration decl = mexp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.getFlag(512)) {
                String msg1 = "'";
                String msg2 = decl.getFlag(1024) ? "' exported but never defined" : (decl.getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', decl, msg1, msg2);
            }
            if (mexp.getFlag(4096)) {
                if (decl.getFlag(1024)) {
                    if (decl.isPrivate()) {
                        if (decl.getFlag(0x1000000)) {
                            this.error('e', decl, "'", "' is declared both private and exported");
                        }
                        decl.setPrivate(false);
                    }
                } else {
                    decl.setPrivate(true);
                }
            }
            if (moduleStatic) {
                decl.setFlag(2048);
                continue;
            }
            if ((!mexp.getFlag(16384) || decl.getFlag(2048)) && Compilation.moduleStatic >= 0 && !mexp.getFlag(32768)) continue;
            decl.setFlag(4096);
        }
        if (!moduleStatic) {
            mexp.declareThis(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveModule(ModuleExp mexp) {
        int numPending = this.pendingImports == null ? 0 : this.pendingImports.size();
        int i = 0;
        while (i < numPending) {
            ModuleInfo info = (ModuleInfo)this.pendingImports.elementAt(i++);
            ScopeExp defs = (ScopeExp)this.pendingImports.elementAt(i++);
            Expression posExp = (Expression)this.pendingImports.elementAt(i++);
            if (mexp != defs) continue;
            ReferenceExp savePos = new ReferenceExp((Object)null);
            savePos.setLine(this);
            this.setLine(posExp);
            require.importDefinitions(null, info, null, this.formStack, defs, this);
            this.setLine(savePos);
            this.pendingImports.setElementAt(null, i - 3);
            this.pendingImports.setElementAt(null, i - 2);
            this.pendingImports.setElementAt(null, i - 1);
        }
        this.processAccesses();
        this.setModule(mexp);
        Compilation save_comp = Compilation.getCurrent();
        try {
            Compilation.setCurrent(this);
            mexp.body = this.makeBody(this.firstForm, mexp);
            this.lexical.pop(mexp);
        }
        finally {
            Compilation.setCurrent(save_comp);
        }
    }

    public Declaration makeRenamedAlias(Declaration decl, ScopeExp templateScope) {
        if (templateScope == null) {
            return decl;
        }
        return this.makeRenamedAlias(decl.getSymbol(), decl, templateScope);
    }

    public Declaration makeRenamedAlias(Object name, Declaration decl, ScopeExp templateScope) {
        Declaration alias = new Declaration(name);
        alias.setAlias(true);
        alias.setPrivate(true);
        alias.context = templateScope;
        ReferenceExp ref = new ReferenceExp(decl);
        ref.setDontDereference(true);
        alias.noteValue(ref);
        return alias;
    }

    public void pushRenamedAlias(Declaration alias) {
        Declaration decl = Translator.getOriginalRef(alias).getBinding();
        ScopeExp templateScope = alias.context;
        decl.setSymbol(null);
        Declaration old = templateScope.lookup(decl.getSymbol());
        if (old != null) {
            templateScope.remove(old);
        }
        templateScope.addDeclaration(alias);
        if (this.renamedAliasStack == null) {
            this.renamedAliasStack = new Stack();
        }
        this.renamedAliasStack.push(old);
        this.renamedAliasStack.push(alias);
        this.renamedAliasStack.push(templateScope);
    }

    public void popRenamedAlias(int count) {
        while (--count >= 0) {
            ScopeExp templateScope = (ScopeExp)this.renamedAliasStack.pop();
            Declaration alias = (Declaration)this.renamedAliasStack.pop();
            Declaration decl = Translator.getOriginalRef(alias).getBinding();
            decl.setSymbol(alias.getSymbol());
            templateScope.remove(alias);
            Object old = this.renamedAliasStack.pop();
            if (old == null) continue;
            templateScope.addDeclaration((Declaration)old);
        }
    }

    public Declaration define(Object name, SyntaxForm nameSyntax, ScopeExp defs) {
        boolean aliasNeeded = nameSyntax != null && nameSyntax.scope != this.currentScope();
        Object declName = aliasNeeded ? new String(name.toString()) : name;
        Declaration decl = defs.getDefine(declName, 'w', this);
        if (aliasNeeded) {
            Declaration alias = this.makeRenamedAlias(name, decl, nameSyntax.scope);
            nameSyntax.scope.addDeclaration(alias);
        }
        this.push(decl);
        return decl;
    }
}

